<!DOCTYPE html>
<html>
<head>
    <title>Payment Received - <?php echo e($order->order_number); ?></title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0;">
    <div style="max-width: 800px; margin: 0 auto; padding: 20px;">
        <h2>Payment Received</h2>
        
        <div style="background-color: #f9f9f9; padding: 20px; border-radius: 4px; margin: 20px 0;">
            <div style="background-color: white; padding: 15px; border-radius: 4px; margin: 15px 0;">
                <p style="margin: 0;"><strong>Order Number:</strong> <?php echo e($order->order_number); ?></p>
                <p style="margin: 5px 0;"><strong>Payment Date:</strong> <?php echo e($payment->created_at->format('M d, Y H:i:s')); ?></p>
                <p style="margin: 5px 0;"><strong>Payment Method:</strong> <?php echo e($payment->paymentMethod->name); ?></p>
                <p style="margin: 5px 0;"><strong>Amount:</strong> ৳<?php echo e(number_format($payment->amount)); ?></p>
                <p style="margin: 5px 0;"><strong>Transaction ID:</strong> <?php echo e($payment->transaction_id); ?></p>
                <p style="margin: 5px 0;"><strong>Sender Number:</strong> <?php echo e($payment->sender_number); ?></p>
            </div>

            <div style="margin-top: 20px;">
                <p><strong>Customer Details:</strong></p>
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 8px 0; width: 150px;"><strong>Name:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($order->contact_name); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; width: 150px;"><strong>Email:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($order->contact_email); ?></td>
                    </tr>
                    <tr>
                        <td style="padding: 8px 0; width: 150px;"><strong>Phone:</strong></td>
                        <td style="padding: 8px 0;"><?php echo e($order->contact_phone); ?></td>
                    </tr>
                </table>
            </div>

            <div style="margin-top: 20px;">
                <p>Please verify this payment and update the status accordingly.</p>
                <p>
                    <a href="<?php echo e(url(route('admin.orders.show', $order->id))); ?>" style="display: inline-block; padding: 10px 20px; background-color: #4CAF50; color: white; text-decoration: none; border-radius: 4px;">View Order Details</a>
                </p>
            </div>
        </div>
        
        <p style="color: #666; font-size: 14px;">This is an automated notification from <?php echo e(config('app.name')); ?></p>
    </div>
</body>
</html> <?php /**PATH /home/techmind/public_html/resources/views/emails/admin/payment-received.blade.php ENDPATH**/ ?>