<?php if($paginator->hasPages()): ?>
    <?php
        $maxLinks = 2;
        $current = $paginator->currentPage();
        $last = $paginator->lastPage();
        $start = max(1, min($current - $maxLinks, $last - 2 * $maxLinks));
        $end = min($last, max(2 * $maxLinks + 1, $current + $maxLinks));
    ?>

    <div class="mn-pro-pagination m-b-15">
        <span>Showing <?php echo e($paginator->firstItem()); ?> to <?php echo e($paginator->lastItem()); ?> of <?php echo e($paginator->total()); ?> item(s)</span>
        <ul class="mn-pro-pagination-inner">
            
            <li>
                <?php if($paginator->onFirstPage()): ?>
                    <span class="disabled"><i class="ri-arrow-left-double-line"></i> Previous</span>
                <?php else: ?>
                    <a href="<?php echo e($paginator->previousPageUrl()); ?>" class="prev"><i class="ri-arrow-left-double-line"></i> Previous</a>
                <?php endif; ?>
            </li>

            
            <?php if($start > 1): ?>
                <li><a href="<?php echo e($paginator->url(1)); ?>">1</a></li>
                <?php if($start > 2): ?><li><span class="dots">...</span></li><?php endif; ?>
            <?php endif; ?>

            
            <?php $__currentLoopData = range($start, $end); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <a href="<?php echo e($paginator->url($i)); ?>" class="<?php echo e($i == $current ? 'active' : ''); ?>"><?php echo e($i); ?></a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <?php if($end < $last): ?>
                <?php if($end < $last - 1): ?><li><span class="dots">...</span></li><?php endif; ?>
                <li><a href="<?php echo e($paginator->url($last)); ?>"><?php echo e($last); ?></a></li>
            <?php endif; ?>

            
            <li>
                <?php if($paginator->hasMorePages()): ?>
                    <a href="<?php echo e($paginator->nextPageUrl()); ?>" class="next">Next <i class="ri-arrow-right-double-line"></i></a>
                <?php else: ?>
                    <span class="disabled">Next <i class="ri-arrow-right-double-line"></i></span>
                <?php endif; ?>
            </li>
        </ul>
    </div>
<?php endif; ?><?php /**PATH /home/techmind/public_html/resources/views/partial/pagination.blade.php ENDPATH**/ ?>