<?php $__env->startSection('title', 'Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Orders</h3>
                    <a href="<?php echo e(route('admin.orders.export')); ?>" class="btn btn-sm btn-outline-success">
                        <i class="fas fa-file-excel me-1"></i> Export
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Status Filter Buttons -->
                <div class="mb-4 d-flex gap-3 justify-content-center align-items-center flex-wrap">
                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('admin.orders', ['status' => $status])); ?>" 
                       class="btn <?php echo e($currentStatus === $status ? 'sb_btn' : 'btn-outline-secondary'); ?> rounded-0">
                        <?php echo e($label); ?>

                        <span class="badge bg-white text-primary ms-2">
                            <?php echo e(App\Models\Order::where('order_status', $status)->count()); ?>

                        </span>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Orders Table -->
                <div class="table-responsive">
                    <table id="ordersTable" class="table table-bordered table-hover">
                        <thead class="bg_sb_primary">
                            <tr>
                                <th>Order #</th>
                                <th>Customer</th>
                                <th>Items</th>
                                <th>Total & Payment</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($order->order_number); ?></td>
                                <td>
                                    <div>
                                        <a href="<?php echo e(route('admin.users.edit', $order->user_id)); ?>" class="text-primary">
                                            <?php echo e($order->contact_name); ?>

                                        </a>
                                    </div>
                                    <small class="text-muted"><i class="fas fa-phone-alt"></i> <?php echo e($order->contact_phone); ?></small>
                                </td>
                                <td>
                                    <?php echo e($order->items->count()); ?> items
                                    <button class="btn btn-sm btn-link view-items-btn" type="button" data-toggle="collapse" data-target="#items-<?php echo e($order->id); ?>">
                                        <i class="fas fa-chevron-down"></i>
                                    </button>
                                    <div class="collapse" id="items-<?php echo e($order->id); ?>">
                                        <div class="card card-body">
                                            <ul class="list-unstyled mb-0">
                                                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="text-sm text-gray-500 mb-1">
                                                    <?php echo e($item->product->title); ?> 
                                                    <span class="text-gray-500">
                                                        (<?php echo e($item->variation->unit_value); ?><?php echo e($item->variation->unit_type); ?>)
                                                        × <?php echo e($item->quantity); ?>

                                                    </span>
                                                </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex flex-column" style="gap: 4px;">
                                        <div class="d-flex" style="gap: 8px;">
                                            <span class="badge bg-<?php echo e($order->payment_status === 'paid' ? 'success' : ($order->payment_status === 'failed' ? 'danger' : ($order->payment_status === 'cancelled' ? 'secondary' : 'warning'))); ?>">
                                                <?php echo e(strtoupper($order->payment_method)); ?> - <?php echo e(ucfirst($order->payment_status ?? 'unpaid')); ?>

                                            </span>
                                        </div>
                                        <div>Total: ৳<?php echo e(number_format($order->total)); ?></div>
                                        <?php if($order->payment_trxid): ?>
                                            <div class="text-muted small"># <?php echo e($order->payment_trxid); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center justify-content-center" style="gap: 10px;">
                                        <?php
                                            $nextStatus = '';
                                            if($order->order_status === 'pending') $nextStatus = 'processing';
                                            elseif($order->order_status === 'processing') $nextStatus = 'shipped';
                                            elseif($order->order_status === 'shipped') $nextStatus = 'delivered';
                                        ?>

                                        <?php if($nextStatus): ?>
                                        <form action="<?php echo e(route('admin.orders.status', $order)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PUT'); ?>
                                            <input type="hidden" name="status" value="<?php echo e($nextStatus); ?>">
                                            <button type="submit" class="btn btn-outline-primary btn-sm" title="Mark as <?php echo e(ucfirst($nextStatus)); ?>">
                                                <i class="fas fa-arrow-right"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>

                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm" type="button" data-toggle="dropdown">
                                                <i class="fas fa-cog"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($status !== $order->order_status): ?>
                                                    <form action="<?php echo e(route('admin.orders.status', $order)); ?>" method="POST" class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PUT'); ?>
                                                        <input type="hidden" name="status" value="<?php echo e($status); ?>">
                                                        <button type="submit" class="dropdown-item">
                                                            Mark as <?php echo e($label); ?>

                                                        </button>
                                                    </form>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo e($order->created_at->format('d M, Y h:i A')); ?></td>
                                <td>
                                    <div class="d-flex align-items-center justify-content-center" style="gap: 10px;">
                                        <a href="<?php echo e(route('admin.orders.show', $order)); ?>" class="btn btn-secondary btn-sm px-3" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.orders.invoice', $order)); ?>" 
                                           class="btn btn-info btn-sm px-3" 
                                           title="Print Invoice"
                                           onclick="event.preventDefault(); printInvoice(this.href);">
                                            <i class="fas fa-file-invoice"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4 d-flex justify-content-end">
                    <?php echo e($orders->appends(['status' => $currentStatus])->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Payment Approval Modal -->
<div class="modal fade" id="approvePaymentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title">
                    <i class="fas fa-check-circle text-success me-2"></i>
                    Confirm Payment Approval
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form action="" method="POST" id="approveForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="status" value="verified">
                <div class="modal-body">
                    <div class="alert alert-warning mb-3">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Please verify payment details before approving.
                    </div>

                    <table class="table table-sm">
                        <tr>
                            <td class="text-muted" width="35%">Payment Method</td>
                            <td><span id="approveModalMethod"></span></td>
                        </tr>
                        <tr>
                            <td class="text-muted">Order Total</td>
                            <td>৳<span id="approveModalTotal"></span></td>
                        </tr>
                        <tr>
                            <td class="text-muted">Amount Paid</td>
                            <td>
                                ৳<span id="approveModalPaid"></span>
                                <span id="approveModalDiff" class="ms-2 small"></span>
                            </td>
                        </tr>
                        <tr>
                            <td class="text-muted">Transaction ID</td>
                            <td><span id="approveModalTrxId" class="font-monospace"></span></td>
                        </tr>
                    </table>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">✓ Approve</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Payment Rejection Modal -->
<div class="modal fade" id="rejectPaymentModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-light">
                <h5 class="modal-title">
                    <i class="fas fa-times-circle text-danger me-2"></i>
                    Reject Payment
                </h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <form action="" method="POST" id="rejectForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="status" value="rejected">
                <div class="modal-body">
                    <div class="alert alert-warning mb-3">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Please provide a reason for rejecting this payment.
                    </div>

                    <div class="preset-messages mb-3">
                        <label class="d-block mb-2">Quick Responses:</label>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary preset-msg" 
                                    data-message="The amount you've sent (৳{paid_amount}) doesn't match the order total (৳{order_total}). Please send the correct amount.">
                                Wrong Amount
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary preset-msg" 
                                    data-message="We couldn't verify this transaction ID in our payment gateway. Please ensure you've sent the payment and provided the correct transaction ID.">
                                Invalid TrxID
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-secondary preset-msg" 
                                    data-message="The payment was sent to the wrong merchant account. Please ensure you're sending to the correct merchant number provided during checkout.">
                                Wrong Receiver
                            </button>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="rejectionNote">Rejection Note:</label>
                        <textarea class="form-control" 
                                id="rejectionNote" 
                                name="admin_note" 
                                rows="3" 
                                required 
                                placeholder="Type or select a preset message above"></textarea>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">✕ Reject</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
$(document).ready(function() {
    $('#ordersTable').DataTable({
        "paging": false,
        "searching": true,
        "ordering": true,
        "info": false,
        "responsive": true,
        "autoWidth": false
    });

    // Toggle arrow icon
    $('.view-items-btn').on('click', function() {
        const isCollapsed = $($(this).data('target')).hasClass('show');
        $(this).find('i').toggleClass('fa-chevron-down fa-chevron-up');
    });
});

function showApproveModal(orderId) {
    const row = $(`button[onclick="showApproveModal(${orderId})"]`).closest('tr');
    
    // Get payment details using data attributes
    const orderTotal = row.find('div[data-total]').data('total');
    const paidAmount = row.find('div[data-amount]').data('amount');
    const paymentMethod = row.find('.badge.bg-info').first().text().trim();
    const trxId = row.find('.text-muted.small').first().text().replace('#', '').trim();

    // Update modal content
    $('#approveModalMethod').text(paymentMethod);
    $('#approveModalTotal').text(orderTotal.toLocaleString());
    $('#approveModalPaid').text(paidAmount.toLocaleString());
    $('#approveModalTrxId').text(trxId);

    // Show amount difference
    if (paidAmount !== orderTotal) {
        const diff = paidAmount - orderTotal;
        if (diff < 0) {
            $('#approveModalDiff').html(`<span class="text-danger">(৳${Math.abs(diff).toLocaleString()} less)</span>`);
        } else {
            $('#approveModalDiff').html(`<span class="text-warning">(৳${diff.toLocaleString()} more)</span>`);
        }
    } else {
        $('#approveModalDiff').html('<span class="text-success">(Exact amount)</span>');
    }

    // Set form action
    $('#approveForm').attr('action', '<?php echo e(url("admin/orders")); ?>/' + orderId + '/payment/status');
    
    $('#approvePaymentModal').modal('show');
}

function showRejectModal(orderId) {
    const row = $(`button[onclick="showRejectModal(${orderId})"]`).closest('tr');
    
    // Store values for template replacement
    const orderTotal = row.find('div:contains("Total:")').first().text().match(/৳([\d,]+)/)[1];
    const paidAmount = row.find('div:contains("Paid Amount:")').first().text().match(/৳([\d,]+)/)[1];
    
    $('#rejectPaymentModal').data('orderTotal', orderTotal);
    $('#rejectPaymentModal').data('paidAmount', paidAmount);
    
    // Set form action with correct order ID
    $('#rejectForm').attr('action', '<?php echo e(url("admin/orders")); ?>/' + orderId + '/payment/status');
    
    // Clear previous note
    $('#rejectionNote').val('');
    
    $('#rejectPaymentModal').modal('show');
}

// Preset message handler
$(document).on('click', '.preset-msg', function() {
    try {
        const modal = $('#rejectPaymentModal');
        const orderTotal = modal.data('orderTotal');
        const paidAmount = modal.data('paidAmount');
        
        if (!orderTotal || !paidAmount) {
            console.error('Missing payment data');
            return;
        }

        let message = $(this).data('message')
            .replace('{order_total}', orderTotal)
            .replace('{paid_amount}', paidAmount);
        
        $('#rejectionNote').val(message);
    } catch (error) {
        console.error('Error setting preset message:', error);
    }
});

function printInvoice(url) {
    const iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    document.body.appendChild(iframe);
    iframe.src = url;
    iframe.onload = function() {
        iframe.contentWindow.print();
        setTimeout(function() {
            document.body.removeChild(iframe);
        }, 1000);
    };
}
</script>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/orders/list.blade.php ENDPATH**/ ?>