<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BlogController;

// Public blog routes
Route::get('/blog', [BlogController::class, 'index'])->name('blog.index');
Route::get('/blog/{slug}', [BlogController::class, 'show'])->name('blog.show');

// Authenticated blog interactions
Route::middleware(['auth', 'verified'])->group(function () {
    // Reactions
    Route::post('/blog/{blog}/react', [BlogController::class, 'react'])->name('blog.react');
    Route::delete('/blog/{blog}/react', [BlogController::class, 'removeReaction'])->name('blog.react.remove');
    
    // Comments
    Route::post('/blog/{blog}/comment', [BlogController::class, 'comment'])->name('blog.comment');
    Route::post('/blog/comment/{comment}/reply', [BlogController::class, 'reply'])->name('blog.comment.reply');
    Route::delete('/blog/comment/{comment}', [BlogController::class, 'deleteComment'])->name('blog.comment.delete');
});
