@extends("general_base")
@section("title", "Shipping Details")
@section("style")
@include('partial.user_styles')
@endsection

@section("content")
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            @include('partial.user_sidebar')
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <h5 class="mb-4">Shipping Details</h5>
                <form action="{{ route('shipping.update') }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_name">Contact Name</label>
                                <input type="text" class="form-control" id="contact_name" name="contact_name" 
                                    value="{{ old('contact_name', auth()->user()->shipping_addr['contact_name'] ?? '') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_phone">Contact Phone</label>
                                <input type="tel" class="form-control" id="contact_phone" name="contact_phone" 
                                    value="{{ old('contact_phone', auth()->user()->shipping_addr['contact_phone'] ?? '') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="whatsapp">WhatsApp Number <span class="text-muted small">(optional)</span></label>
                                <input type="tel" class="form-control" id="whatsapp" name="whatsapp" 
                                    value="{{ old('whatsapp', auth()->user()->shipping_addr['whatsapp'] ?? '') }}">
                                <small class="text-muted fs-12">Leave empty if same as contact phone</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contact_email">Email Address <span class="text-muted small">(optional)</span></label>
                                <input type="email" class="form-control" id="contact_email" name="contact_email" 
                                    value="{{ old('contact_email', auth()->user()->shipping_addr['contact_email'] ?? '') }}">
                                <small class="text-muted fs-12">Alternative email for shipping updates</small>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="address">Address</label>
                                <textarea class="form-control" id="address" name="address" rows="3" required>{{ old('address', auth()->user()->shipping_addr['address'] ?? '') }}</textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city" 
                                    value="{{ old('city', auth()->user()->shipping_addr['city'] ?? '') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="state">State</label>
                                <input type="text" class="form-control" id="state" name="state" 
                                    value="{{ old('state', auth()->user()->shipping_addr['state'] ?? '') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="postal_code">Postal Code</label>
                                <input type="text" class="form-control" id="postal_code" name="postal_code" 
                                    value="{{ old('postal_code', auth()->user()->shipping_addr['postal_code'] ?? '') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="mn-btn-2">
                            <span><i class="ri-save-line me-1"></i> Save Address</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection 