@extends("general_base")
@section("title", "My Account")
@section("style")
@include('partial.user_styles')
<style>
.profile-header {
    display: flex;
    align-items: center;
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #f5f5f5;
}
.profile-avatar {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    background: #f5f5f5;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 40px;
    color: #313b50;
    margin-right: 20px;
}
.profile-info h4 {
    margin: 0;
    color: #313b50;
    font-size: 24px;
}
.profile-info p {
    margin: 5px 0 0;
    color: #666;
}
.verification-badge {
    display: inline-flex;
    align-items: center;
    padding: 3px 10px;
    border-radius: 15px;
    font-size: 12px;
    margin-left: 10px;
}
.verification-badge.verified {
    background: #e8f5e9;
    color: #2e7d32;
}
.verification-badge.unverified {
    background: #ffebee;
    color: #c62828;
}
.verification-badge i {
    margin-right: 5px;
}
</style>
@endsection
@section("content")
<div class="container account-wrapper">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            @include('partial.user_sidebar')
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="account-content">
                <!-- Profile Header -->
                <div class="profile-header">
                    <div class="profile-avatar">
                        <i class="ri-user-smile-line"></i>
                    </div>
                    <div class="profile-info">
                        <h4>{{ auth()->user()->first_name }} {{ auth()->user()->last_name }}</h4>
                        <p>{{ auth()->user()->email }}
                            @if(auth()->user()->email_verified_at)
                                <span class="verification-badge verified">
                                    <i class="ri-checkbox-circle-line"></i> Verified
                                </span>
                            @else
                                <span class="verification-badge unverified">
                                    <i class="ri-error-warning-line"></i> Unverified
                                </span>
                            @endif
                        </p>
                    </div>
                </div>

                <!-- Profile Form -->
                <form action="{{ route('profile.update') }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" 
                                    value="{{ old('first_name', auth()->user()->first_name) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" 
                                    value="{{ old('last_name', auth()->user()->last_name) }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">Email Address</label>
                                <input type="email" class="form-control" id="email" name="email" 
                                    value="{{ old('email', auth()->user()->email) }}" required>
                                @if(!auth()->user()->email_verified_at)
                                    <small class="text-danger">
                                        Your email is not verified. 
                                        <a href="{{ route('verification.notice') }}">Click here to verify</a>
                                    </small>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone">Phone Number</label>
                                <input type="tel" class="form-control" id="phone" name="phone" 
                                    value="{{ old('phone', auth()->user()->phone) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="mn-btn-2">
                            <span><i class="ri-save-line me-1"></i> Save Changes</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection