<!DOCTYPE html>
<html>
<head>
    <title>Order Confirmation - {{ $order->order_number }}</title>
</head>
<body style="font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 0;">
    <div style="max-width: 800px; margin: 0 auto; padding: 20px;">
        <h2>Thank you for your order!</h2>
        
        <div style="background-color: #f9f9f9; padding: 20px; border-radius: 4px; margin: 20px 0;">
            <p>Dear {{ $order->contact_name }},</p>
            <p>Your order has been successfully placed. Here are your order details:</p>

            <div style="background-color: white; padding: 15px; border-radius: 4px; margin: 15px 0;">
                <p style="margin: 0;"><strong>Order ID:</strong> {{ $order->order_number }}</p>
                <p style="margin: 5px 0;"><strong>Order Date:</strong> {{ $order->created_at->format('M d, Y') }}</p>
                
                <table style="width: 100%; margin-top: 15px;">
                    <tr style="border-top: 1px solid #eee;">
                        <td style="padding: 8px 0; width: 150px;">Subtotal</td>
                        <td style="padding: 8px 0; text-align: right;">({{ $order->total_items }} items) - ৳{{ number_format($order->subtotal) }}</td>
                    </tr>
                    @if($order->discount > 0)
                    <tr style="border-top: 1px solid #eee;">
                        <td style="padding: 8px 0; width: 150px;">Discount</td>
                        <td style="padding: 8px 0; text-align: right;">-৳{{ number_format($order->discount) }}</td>
                    </tr>
                    @endif
                    <tr style="border-top: 1px solid #eee;">
                        <td style="padding: 8px 0; width: 150px;">Delivery Charge</td>
                        <td style="padding: 8px 0; text-align: right;">৳{{ number_format($order->delivery_charge) }}</td>
                    </tr>
                    <tr style="border-top: 2px solid #eee; font-weight: bold;">
                        <td style="padding: 8px 0; width: 150px;">Total</td>
                        <td style="padding: 8px 0; text-align: right;">৳{{ number_format($order->total) }}</td>
                    </tr>
                </table>
            </div>

            <div style="margin-top: 20px;">
                <p><strong>Delivery Address:</strong></p>
                <p style="margin: 5px 0;">{{ $order->address }}</p>
                <p style="margin: 5px 0;">{{ $order->city }}, {{ $order->state }} {{ $order->postal_code }}</p>
            </div>

            <div style="margin-top: 20px;">
                <p>You can track your order or view the invoice using these links:</p>
                <p>
                    <a href="{{ url(route('product.order.track', ['order_id' => $order->order_number, 'email' => $order->contact_email])) }}" style="display: inline-block; padding: 10px 20px; background-color: #4CAF50; color: white; text-decoration: none; border-radius: 4px; margin-right: 10px;">Track Order</a>
                    <a href="{{ url(route('product.order.invoice', $order->order_number)) }}" style="display: inline-block; padding: 10px 20px; background-color: #2196F3; color: white; text-decoration: none; border-radius: 4px;">View Invoice</a>
                </p>
            </div>
        </div>
        
        <p style="color: #666; font-size: 14px;">Thank you for shopping with {{ config('app.name') }}</p>
    </div>
</body>
</html> 