@extends('admin_base')

@section('title', 'Users')

@section('style')
<style>
.dt-buttons {
    margin-bottom: 15px;
}
.dt-button {
    padding: 5px 15px;
    border-radius: 5px;
    background-color: #159abe;
    color: white;
    border: none;
    margin-right: 10px;
}
.dt-button:hover {
    background-color: #2e3eb8;
}
.table-actions {
    display: flex;
    gap: 10px;
    justify-content: center;
}
.table-actions button {
    padding: 5px 10px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
}
.edit-btn {
    background-color: #ffc107;
    color: #000;
}
.delete-btn {
    background-color: #dc3545;
    color: white;
}
.status-icons {
    display: flex;
    gap: 15px;
    justify-content: center;
}
.status-icon {
    font-size: 1.2rem;
}
.status-icon.active {
    color: #28a745;
}
.status-icon.inactive {
    color: #dc3545;
}
</style>
@parent
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Users List</h3>
    </div>
    <div class="card-body">
        <div class="table-responsive" style="overflow-x:auto;">
            <table id="usersTable" class="table table-bordered table-striped text-center mb-0">
                <thead class="bg_sb_primary">
                    <tr>
                        <th>#</th>
                        <th>Full Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Role</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $key => $user)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $user->first_name }} {{ $user->last_name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>{{ $user->phone }}</td>
                        <td>
                            <div class="status-icons">
                                <i class="fas fa-user status-icon {{ $user->is_active ? 'active' : 'inactive' }}" 
                                   title="{{ $user->is_active ? 'Account Active' : 'Account Inactive' }}"></i>
                                <i class="fas fa-envelope status-icon {{ $user->email_verified_at ? 'active' : 'inactive' }}" 
                                   title="{{ $user->email_verified_at ? 'Email Verified' : 'Email Not Verified' }}"></i>
                            </div>
                        </td>
                        <td>{{ ucfirst($user->role) }}</td>
                        <td>
                            <div class="table-actions">
                                <button class="edit-btn" onclick="location.href='{{ route('admin.users.edit', $user->id) }}'">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="delete-btn" onclick="showDeleteModal({{ $user->id }}, '{{ $user->first_name }} {{ $user->last_name }}')">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete user: <strong id="deleteUserName"></strong>?
                <br>
                <small class="text-danger">This action cannot be undone!</small>
            </div>
            <div class="modal-footer d-flex justify-content-between p-1">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times"></i> Cancel
                </button>
                <button type="button" class="btn btn-danger" id="confirmDelete">
                    <i class="fas fa-trash"></i> Delete User
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
$(document).ready(function() {
    $('#usersTable').DataTable({
        responsive: true,
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],
        order: [[0, 'asc']],
        pageLength: 10,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries per page",
            zeroRecords: "No matching records found",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            infoEmpty: "Showing 0 to 0 of 0 entries",
            infoFiltered: "(filtered from _MAX_ total entries)"
        }
    });
});

let userIdToDelete = null;

function showDeleteModal(userId, userName) {
    userIdToDelete = userId;
    $('#deleteUserName').text(userName);
    $('#deleteModal').modal('show');
}

$('#confirmDelete').click(function() {
    if (userIdToDelete) {
        fetch(`/admin/users/${userIdToDelete}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            $('#deleteModal').modal('hide');
            if (data.success) {
                // Show success message using session flash
                window.location.href = "{{ route('admin.users') }}?success=User deleted successfully";
            } else {
                // Show error message using session flash
                window.location.href = "{{ route('admin.users') }}?error=Error deleting user";
            }
        })
        .catch(error => {
            $('#deleteModal').modal('hide');
            window.location.href = "{{ route('admin.users') }}?error=Error deleting user";
        });
    }
});
</script>
@endsection