@extends('admin_base')

@section('title', 'Edit User')

@section('style')
<style>
.form-label {
    font-weight: 600;
}
.required:after {
    content: ' *';
    color: red;
}
.info-section {
    background-color: #f8f9fa;
    border-radius: 5px;
    padding: 20px;
    margin-top: 20px;
}
.info-section h4 {
    color: #159abe;
    margin-bottom: 20px;
    font-size: 1.1rem;
}
.info-item {
    margin-bottom: 15px;
}
.info-label {
    font-weight: 600;
    color: #6c757d;
    font-size: 0.9rem;
}
.info-value {
    color: #2c3338;
    margin-top: 3px;
}
.badge-2fa {
    font-size: 0.8rem;
    padding: 5px 10px;
    border-radius: 15px;
}
.badge-2fa.enabled {
    background-color: #28a745;
    color: white;
}
.badge-2fa.disabled {
    background-color: #dc3545;
    color: white;
}
.recovery-codes {
    background: #f8f9fa;
    padding: 10px 15px;
    border-radius: 4px;
    border: 1px solid #dee2e6;
    margin-top: 5px;
    font-family: monospace;
}
.recovery-code {
    padding: 2px 0;
    color: #495057;
}
.form-actions {
    background-color: #fff;
    padding: 15px 0;
    margin: 20px 0;
    border-bottom: 1px solid #dee2e6;
    text-align: center;
}
.recovery-code-badge {
    display: inline-block;
    background: #e9ecef;
    color: #495057;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.85rem;
    margin: 2px;
    font-family: monospace;
}
</style>
@endsection

@section('content')
<div class="card">
    <div class="card-header bg_sb_primary">
        <h3 class="card-title">Edit User: {{ $user->first_name }} {{ $user->last_name }}</h3>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="first_name" class="form-label required">First Name</label>
                    <input type="text" class="form-control @error('first_name') is-invalid @enderror" 
                           id="first_name" name="first_name" 
                           value="{{ old('first_name', $user->first_name) }}" required>
                    @error('first_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="last_name" class="form-label required">Last Name</label>
                    <input type="text" class="form-control @error('last_name') is-invalid @enderror" 
                           id="last_name" name="last_name" 
                           value="{{ old('last_name', $user->last_name) }}" required>
                    @error('last_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label required">Email</label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           id="email" name="email" 
                           value="{{ old('email', $user->email) }}" required>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="phone" class="form-label">Phone</label>
                    <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                           id="phone" name="phone" 
                           value="{{ old('phone', $user->phone) }}">
                    @error('phone')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="password" class="form-label">New Password</label>
                    <input type="password" class="form-control @error('password') is-invalid @enderror" 
                           id="password" name="password">
                    <small class="form-text text-muted">Leave blank to keep current password</small>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <label for="password_confirmation" class="form-label">Confirm New Password</label>
                    <input type="password" class="form-control" 
                           id="password_confirmation" name="password_confirmation">
                </div>

                <div class="col-md-6 mb-3">
                    <label for="role" class="form-label required">Role</label>
                    <select class="form-control @error('role') is-invalid @enderror" 
                            id="role" name="role" required>
                        <option value="">Select Role</option>
                        <option value="user" {{ old('role', $user->role) == 'user' ? 'selected' : '' }}>User</option>
                        <option value="admin" {{ old('role', $user->role) == 'admin' ? 'selected' : '' }}>Admin</option>
                    </select>
                    @error('role')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-md-6 mb-3">
                    <div class="form-check mt-4">
                        <input type="checkbox" class="form-check-input" 
                               id="is_active" name="is_active" value="1" 
                               {{ old('is_active', $user->is_active) ? 'checked' : '' }}>
                        <label class="form-check-label" for="is_active">Active Account</label>
                    </div>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" 
                               id="email_verified" name="email_verified" value="1" 
                               {{ old('email_verified', $user->email_verified_at) ? 'checked' : '' }}>
                        <label class="form-check-label" for="email_verified">Email Verified</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="sb_btn">
                    <i class="fas fa-save"></i> Update User
                </button>
                <a href="{{ route('admin.users') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>

            <div class="info-section">
                <h4><i class="fas fa-info-circle"></i> Additional Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Account Created</div>
                            <div class="info-value">{{ $user->created_at->format('F j, Y \a\t g:i A') }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Last Updated</div>
                            <div class="info-value">{{ $user->updated_at->format('F j, Y \a\t g:i A') }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Email Verification Date</div>
                            <div class="info-value">
                                @if($user->email_verified_at)
                                    {{ $user->email_verified_at->format('F j, Y \a\t g:i A') }}
                                @else
                                    <span class="text-danger">Not verified</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Two-Factor Authentication</div>
                            <div class="info-value">
                                @if($user->two_factor_enabled)
                                    <span class="badge-2fa enabled">
                                        <i class="fas fa-shield-alt"></i> Enabled
                                    </span>
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            Confirmed at: {{ $user->two_factor_confirmed_at ? $user->two_factor_confirmed_at->format('F j, Y \a\t g:i A') : 'Not confirmed' }}
                                        </small>
                                    </div>
                                @else
                                    <span class="badge-2fa disabled">
                                        <i class="fas fa-shield-alt"></i> Disabled
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Recovery Codes</div>
                            <div class="info-value">
                                @if($user->two_factor_recovery_codes)
                                    <span class="text-success mb-2 d-block">
                                        <i class="fas fa-key"></i> Recovery codes are available
                                    </span>
                                    <div>
                                        @foreach(json_decode($user->two_factor_recovery_codes) as $code)
                                            <span class="recovery-code-badge">{{ $code }}</span>
                                        @endforeach
                                    </div>
                                @else
                                    <span class="text-danger">
                                        <i class="fas fa-times-circle"></i> No recovery codes generated
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if($user->shipping_addr)
            <div class="info-section">
                <h4><i class="fas fa-shipping-fast"></i> Shipping Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Contact Person</div>
                            <div class="info-value">{{ $user->shipping_addr['contact_name'] ?? 'N/A' }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Contact Phone</div>
                            <div class="info-value">
                                {{ $user->shipping_addr['contact_phone'] ?? 'N/A' }}
                                @if(isset($user->shipping_addr['whatsapp']))
                                    <br>
                                    <small class="text-success">
                                        <i class="fab fa-whatsapp"></i> WhatsApp: {{ $user->shipping_addr['whatsapp'] }}
                                    </small>
                                @endif
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Contact Email</div>
                            <div class="info-value">{{ $user->shipping_addr['contact_email'] ?? 'N/A' }}</div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Delivery Address</div>
                            <div class="info-value">{{ $user->shipping_addr['address'] ?? 'N/A' }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">City</div>
                            <div class="info-value">{{ $user->shipping_addr['city'] ?? 'N/A' }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">State</div>
                            <div class="info-value">{{ $user->shipping_addr['state'] ?? 'N/A' }}</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Postal Code</div>
                            <div class="info-value">{{ $user->shipping_addr['postal_code'] ?? 'N/A' }}</div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </form>
    </div>
</div>
@endsection 