@extends('admin_base')

@section('title', 'Best Deals')

@section('content')
<div class="card">
    <div class="card-header">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="card-title">Best Deals</h3>
            <a href="{{ route('admin.deals.create') }}" class="sb_btn">
                <i class="fas fa-plus"></i> Add New Deal
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="dealsTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Products</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($deals as $deal)
                    <tr>
                        <td>{{ $deal->id }}</td>
                        <td>{{ $deal->name }}</td>
                        <td>{{ $deal->start_date->format('M d, Y h:i A') }}</td>
                        <td>{{ $deal->end_date->format('M d, Y h:i A') }}</td>
                        <td>
                            <span class="badge badge-{{ $deal->status ? 'success' : 'danger' }}">
                                {{ $deal->status ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>{{ $deal->products->count() }} products</td>
                        <td>
                            <div class="btn-group">
                                <a href="{{ route('admin.deals.edit', $deal) }}" class="btn btn-sm btn-info mr-2">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-danger" onclick="confirmDelete({{ $deal->id }})">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                            <form id="delete-form-{{ $deal->id }}" action="{{ route('admin.deals.destroy', $deal) }}" method="POST" style="display: none;">
                                @csrf
                                @method('DELETE')
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
$(document).ready(function() {
    $('#dealsTable').DataTable({
        "order": [[0, "desc"]]
    });
});

function confirmDelete(dealId) {
    if (confirm('Are you sure you want to delete this deal?')) {
        document.getElementById('delete-form-' + dealId).submit();
    }
}
</script>
@endsection 