@extends('admin_base')

@section('title', 'Edit Best Deal')

@section('style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
<style>
.select2-container {
    width: 100% !important;
}
.select2-selection {
    height: auto !important;
    min-height: 38px !important;
}
</style>
@endsection

@section('content')
<div class="card">
    <div class="card-header">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="card-title">Edit Best Deal</h3>
            <a href="{{ route('admin.deals') }}" class="sb_btn">
                <i class="fas fa-list"></i> All Deals
            </a>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.deals.update', $deal) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="name">Deal Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $deal->name) }}" required>
                        @error('name')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-control" id="status" name="status">
                            <option value="1" {{ old('status', $deal->status) ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ old('status', $deal->status) ? '' : 'selected' }}>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="start_date">Start Date <span class="text-danger">*</span></label>
                        <input type="datetime-local" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date', $deal->start_date->format('Y-m-d\TH:i')) }}" required>
                        @error('start_date')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="end_date">End Date <span class="text-danger">*</span></label>
                        <input type="datetime-local" class="form-control @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date', $deal->end_date->format('Y-m-d\TH:i')) }}" required>
                        @error('end_date')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $deal->description) }}</textarea>
                        @error('description')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="products">Select Products <span class="text-danger">*</span></label>
                        <select class="form-control select2bs5 @error('products') is-invalid @enderror" id="products" name="products[]" multiple required>
                            @foreach($products as $product)
                            <option value="{{ $product->id }}" {{ (old('products', $selectedProducts) && in_array($product->id, old('products', $selectedProducts))) ? 'selected' : '' }}>
                                {{ $product->title }}
                            </option>
                            @endforeach
                        </select>
                        @error('products')
                        <span class="invalid-feedback">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="text-right mt-3">
                <button type="submit" class="sb_btn">Update Deal</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    $('.select2bs5').select2({
        theme: 'bootstrap-5',
        placeholder: 'Select products',
        allowClear: true
    });
});
</script>
@endsection 