@extends("admin_base")
@section("title", "Dashboard")
@section("style")
<style>
.metric-card {
    background: #fff;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.04);
    transition: transform 0.2s;
}
.metric-card:hover {
    transform: translateY(-2px);
}
.metric-icon {
    color: #159abe;
    font-size: 24px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: transform 0.2s;
}

.metric-icon.orders {
    background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(79, 70, 229, 0.2);
}

.metric-icon.revenue {
    background: linear-gradient(135deg, #34d399 0%, #059669 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(5, 150, 105, 0.2);
}

.metric-icon.customers {
    background: linear-gradient(135deg, #f472b6 0%, #db2777 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(219, 39, 119, 0.2);
}

.metric-icon.products {
    background: linear-gradient(135deg, #fbbf24 0%, #d97706 100%);
    color: white;
    box-shadow: 0 4px 12px rgba(217, 119, 6, 0.2);
}

.metric-value {
    font-size: 24px;
    font-weight: 600;
    margin: 10px 0;
}
.metric-label {
    color: #6b7280;
    font-size: 14px;
}
.metric-trend {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 8px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.metric-trend.positive {
    background-color: #dcfce7;
    color: #059669;
}

.metric-trend.negative {
    background-color: #fee2e2;
    color: #dc2626;
}

.metric-trend i {
    font-size: 14px;
}
.metric-trend.text-success {
    color: #10B981;
}
.metric-trend.text-danger {
    color: #EF4444;
}
.chart-card {
    background: #fff;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.04);
    height: 100%;
}
.chart-title {
    font-size: 16px;
    font-weight: 600;
    margin-bottom: 15px;
    color: #374151;
}
.table-card {
    background: #fff;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.04);
}
.status-badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}
.status-pending { background: #FEF3C7; color: #92400E; }
.status-processing { background: #DBEAFE; color: #1E40AF; }
.status-shipped { background: #D1FAE5; color: #065F46; }
.status-delivered { background: #BBF7D0; color: #166534; }
.status-cancelled { background: #FEE2E2; color: #991B1B; }
.stock-warning {
    padding: 8px 12px;
    border-radius: 8px;
    margin-bottom: 8px;
    font-size: 13px;
}
.stock-critical { background: #FEE2E2; color: #991B1B; }
.stock-low { background: #FEF3C7; color: #92400E; }

/* Add loading state styles */
.chart-loading {
    min-height: 300px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f9fafb;
    border-radius: 8px;
}

.chart-loading-spinner {
    width: 40px;
    height: 40px;
    border: 3px solid #e5e7eb;
    border-top-color: #4F46E5;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

.chart-wrapper {
    position: relative;
    height: 350px;  /* Standardize height for all charts */
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* Optimize layout stability */
.metric-card {
    min-height: 160px;
}
.chart-card {
    min-height: 380px;
}

.metric-card {
    background: #fff;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.04);
    transition: transform 0.2s;
}

.metric-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
}

.metric-value {
    font-size: 24px;
    font-weight: 600;
    color: #111827;
    display: flex;
    align-items: center;
}

.metric-value .currency {
    font-family: 'Hind Siliguri', sans-serif;
    margin-right: 2px;
}

.metric-label {
    color: #6b7280;
    font-size: 14px;
    margin-bottom: 10px;
}

.metric-trend {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 4px 8px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.metric-trend.positive {
    background-color: #dcfce7;
    color: #059669;
}

.metric-trend.negative {
    background-color: #fee2e2;
    color: #dc2626;
}

.payment-methods-legend {
    font-size: 0.875rem;
    padding: 1rem 0;
}

.payment-method-item {
    display: inline-flex;
    align-items: center;
    margin: 0 12px;  /* Add horizontal spacing */
    white-space: nowrap;  /* Prevent wrapping */
}

.payment-method-dot {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    display: inline-block;
    margin-right: 6px;
}

.section-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 1rem;
}

.section-title {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1rem;
    font-weight: 600;
    color: #111827;
}

.section-title i {
    color: #f59e0b;
}

.view-all-link {
    font-size: 0.875rem;
    color: #374151;  /* Changed to dark gray */
    text-decoration: none;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

.view-all-link:hover {
    text-decoration: underline;
}

.table a {
    color: #374151;  /* Changed to dark gray */
    text-decoration: none;
}

.table a:hover {
    color: #111827;  /* Darker on hover */
}

.stock-warnings-container {
    max-height: 400px;
    overflow-y: auto;
    padding-right: 0.5rem;
}

.stock-warnings-container::-webkit-scrollbar {
    width: 6px;
}

.stock-warnings-container::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 3px;
}

.stock-warnings-container::-webkit-scrollbar-thumb {
    background: #d1d5db;
    border-radius: 3px;
}

.stock-warnings-container::-webkit-scrollbar-thumb:hover {
    background: #9ca3af;
}

.stock-warning {
    padding: 0.75rem;
    border-radius: 0.5rem;
    margin-bottom: 0.5rem;
    transition: transform 0.1s ease;
}

.stock-warning:hover {
    transform: translateX(4px);
}

.stock-warning.critical {
    background-color: #fee2e2;
}

.stock-warning.low {
    background-color: #fff7ed;
}

.stock-warning-title {
    font-weight: 600;
    color: #111827;
    margin-bottom: 0.25rem;
}

.stock-warning-info {
    color: #4b5563;
    font-size: 0.875rem;
}

.stock-count {
    color: #dc2626;
    font-weight: 500;
}

.stock-count.out {
    color: #991b1b;  /* Darker red for out of stock */
}

.status-badge {
    padding: 0.375rem 0.75rem;
    border-radius: 9999px;
    font-size: 0.75rem;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
}
</style>
@endsection

@section("content")
<div class="container-fluid">
    <!-- Key Metrics -->
    <div class="row mb-4">
        <!-- Monthly Metrics -->
        <div class="col-md-6">
            <div class="row">
                <div class="col-md-6 mb-md-0 mb-2">
                    <div class="metric-card">
                        <div class="metric-header">
                            <i class="fas fa-shopping-cart metric-icon"></i>
                            <div class="metric-value">{{ $metrics['monthly']['total_orders'] }}</div>
                        </div>
                        <div class="metric-label">Total Orders</div>
                        <div class="metric-trend {{ $metrics['growth']['orders_growth'] >= 0 ? 'positive' : 'negative' }}">
                            <i class="fas fa-{{ $metrics['growth']['orders_growth'] >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                            {{ abs($metrics['growth']['orders_growth']) }}% today
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-md-0 mb-2">
                    <div class="metric-card">
                        <div class="metric-header">
                            <i class="fas fa-coins metric-icon"></i>
                            <div class="metric-value">
                                <span class="currency">৳</span>{{ number_format($metrics['monthly']['total_revenue']) }}
                            </div>
                        </div>
                        <div class="metric-label">Total Revenue</div>
                        <div class="metric-trend {{ $metrics['growth']['revenue_growth'] >= 0 ? 'positive' : 'negative' }}">
                            <i class="fas fa-{{ $metrics['growth']['revenue_growth'] >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                            {{ abs($metrics['growth']['revenue_growth']) }}% today
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- All-time Metrics -->
        <div class="col-md-6">
            <div class="row">
                <div class="col-md-6 mb-md-0 mb-2">
                    <div class="metric-card">
                        <div class="metric-header">
                            <i class="fas fa-users metric-icon"></i>
                            <div class="metric-value">{{ $metrics['all_time']['total_customers'] }}</div>
                        </div>
                        <div class="metric-label">Total Customers</div>
                        <div class="metric-trend {{ $metrics['growth']['customers_growth'] >= 0 ? 'positive' : 'negative' }}">
                            <i class="fas fa-{{ $metrics['growth']['customers_growth'] >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                            {{ abs($metrics['growth']['customers_growth']) }}% today
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-md-0 mb-2">
                    <div class="metric-card">
                        <div class="metric-header">
                            <i class="fas fa-box metric-icon"></i>
                            <div class="metric-value">{{ $metrics['all_time']['total_products'] }}</div>
                        </div>
                        <div class="metric-label">Total Products</div>
                        <div class="metric-trend {{ $metrics['growth']['products_growth'] >= 0 ? 'positive' : 'negative' }}">
                            <i class="fas fa-{{ $metrics['growth']['products_growth'] >= 0 ? 'arrow-up' : 'arrow-down' }}"></i>
                            {{ abs($metrics['growth']['products_growth']) }}% today
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <div class="col-md-8 mb-md-0 mb-2">
            <div class="chart-card">
                <h5 class="chart-title">Revenue Overview ({{ now()->format('M Y') }})</h5>
                <div class="chart-wrapper">
                    <div id="revenueChartLoading" class="chart-loading">
                        <div class="chart-loading-spinner"></div>
                    </div>
                    <canvas id="revenueChart" style="display: none;"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-md-0 mb-2">
            <div class="chart-card">
                <h5 class="chart-title">Order Status Distribution ({{ now()->format('M Y') }})</h5>
                <div class="chart-wrapper">
                    <div id="orderStatusChartLoading" class="chart-loading">
                        <div class="chart-loading-spinner"></div>
                    </div>
                    <canvas id="orderStatusChart" style="display: none;"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-6 mb-md-0 mb-2">
            <div class="chart-card">
                <h5 class="chart-title">Top Selling Products ({{ now()->format('M Y') }})</h5>
                <div class="chart-wrapper">
                    <div id="topProductsChartLoading" class="chart-loading">
                        <div class="chart-loading-spinner"></div>
                    </div>
                    <canvas id="topProductsChart" style="display: none;"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-md-0 mb-2">
            <div class="chart-card">
                <h5 class="chart-title">Payment Methods Distribution ({{ now()->format('M Y') }})</h5>
                <div class="chart-wrapper">
                    <div id="paymentMethodsChartLoading" class="chart-loading">
                        <div class="chart-loading-spinner"></div>
                    </div>
                    <canvas id="paymentMethodsChart" style="display: none;"></canvas>
                </div>
                <div class="payment-methods-legend text-center">
                    @foreach($charts['payment_methods']['labels'] as $index => $label)
                    <span class="payment-method-item">
                        <span class="payment-method-dot" style="background-color: {{ ['#F472B6', '#60A5FA', '#34D399', '#A78BFA', '#EC4899'][$index % 5] }}"></span>
                        {{ $label }}
                    </span>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Latest Orders and Stock Warnings -->
    <div class="row">
        <div class="col-md-8 mb-md-0 mb-2">
            <div class="table-card">
                <div class="section-header">
                    <h5 class="section-title">Recent Orders</h5>
                    @if($total_orders > 10)
                    <a href="{{ route('admin.orders') }}" class="view-all-link">
                        View All Orders <i class="fas fa-arrow-right"></i>
                    </a>
                    @endif
                </div>
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Customer</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($latest_orders->take(10) as $order)
                            <tr>
                                <td>
                                    <a href="{{ route('admin.orders.show', $order->id) }}">
                                        {{ $order->order_number }}
                                    </a>
                                </td>
                                <td>
                                    <a href="{{ route('admin.users.edit', $order->user_id) }}">
                                        {{ $order->contact_name }}
                                    </a>
                                </td>
                                <td>৳{{ number_format($order->total) }}</td>
                                <td>
                                    <span class="status-badge status-{{ $order->order_status }}">
                                        {{ ucfirst($order->order_status) }}
                                    </span>
                                </td>
                                <td>{{ $order->created_at->format('d M, Y h:i A') }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- Stock Warnings section -->
        <div class="col-md-4 mb-md-0 mb-2">
            <div class="table-card">
                <div class="section-header">
                    <h5 class="section-title">
                        <i class="fas fa-exclamation-triangle"></i>
                        Stock Warnings
                    </h5>
                </div>
                <div class="stock-warnings-container">
                    @forelse($stock_warnings->take(10) as $warning)
                    <a href="{{ route('admin.products.edit', $warning['product_id']) }}" style="text-decoration: none; display: block;">
                        <div class="stock-warning {{ $warning['level'] }}">
                            <div class="stock-warning-title">{{ $warning['product'] }}</div>
                            <div class="stock-warning-info">
                                {{ $warning['variant'] }} - 
                                <span class="stock-count {{ $warning['stock'] === 0 ? 'out' : '' }}">
                                    {{ $warning['stock_text'] }}
                                </span>
                            </div>
                        </div>
                    </a>
                    @empty
                    <p class="text-muted">No stock warnings</p>
                    @endforelse
                </div>
            </div>

            <div class="table-card">
                <h5 class="chart-title">Blog Statistics</h5>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <span>Total Posts</span>
                    <strong>{{ $blog_stats['total_posts'] }}</strong>
                </div>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <span>Total Comments</span>
                    <strong>{{ $blog_stats['total_comments'] }}</strong>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                    <span>Total Reactions</span>
                    <strong>{{ $blog_stats['total_reactions'] }}</strong>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section("script")
<script src="{{ asset('admin/js/chart.js') }}"></script>
<script>
// Chart configuration defaults
Chart.defaults.font.family = '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif';
Chart.defaults.font.size = 13;
Chart.defaults.plugins.tooltip.cornerRadius = 4;
Chart.defaults.plugins.tooltip.backgroundColor = 'rgba(0, 0, 0, 0.8)';
Chart.defaults.plugins.tooltip.padding = 8;

// Diverse color palette (distinctly different colors)
const colorPalette = [
    '#FF6B6B',  // Coral Red
    '#4ECDC4',  // Turquoise
    '#45B7D1',  // Sky Blue
    '#96CEB4',  // Sage Green
    '#FFEEAD',  // Cream Yellow
    '#D4A5A5',  // Dusty Rose
    '#9B5DE5',  // Purple
    '#F15BB5',  // Pink
    '#00BBF9',  // Bright Blue
    '#00F5D4',  // Mint
    '#FEE440',  // Yellow
    '#F29E4C',  // Orange
    '#4B4453',  // Dark Gray
    '#B0A8B9',  // Light Gray
    '#845EC2',  // Deep Purple
    '#FF9671',  // Peach
    '#FFC75F',  // Light Orange
    '#008F7A',  // Deep Green
    '#C34A36',  // Rust Red
    '#FF8066'   // Salmon
];

// Function to get well-distributed colors based on count
function getDistributedColors(count) {
    // If count is more than available colors, cycle through them
    const finalColors = [];
    for (let i = 0; i < count; i++) {
        // Use modulo to cycle through colors if count > colorPalette.length
        const index = i % colorPalette.length;
        // Shift starting point for each cycle to avoid same color patterns
        const shiftedIndex = (index * 7) % colorPalette.length; // Use prime number for better distribution
        finalColors.push(colorPalette[shiftedIndex]);
    }
    return finalColors;
}

// Initialize charts after DOM is fully loaded
document.addEventListener('DOMContentLoaded', function() {
    // Helper function to initialize chart with loading state
    function initializeChart(chartId, loadingId, config) {
        const canvas = document.getElementById(chartId);
        const loading = document.getElementById(loadingId);
        
        canvas.style.display = 'none';
        loading.style.display = 'flex';
        
        setTimeout(() => {
            const chart = new Chart(canvas, {
                ...config,
                options: {
                    ...config.options,
                    maintainAspectRatio: false,
                    responsive: true
                }
            });
            
            loading.style.display = 'none';
            canvas.style.display = 'block';
        }, 300);
    }

    // Revenue Chart (bar chart)
    initializeChart('revenueChart', 'revenueChartLoading', {
        type: 'bar',
        data: {
            labels: {!! json_encode($charts['revenue']['labels']) !!},
            datasets: [{
                label: 'Revenue',
                data: {!! json_encode($charts['revenue']['data']) !!},
                backgroundColor: '#1cbce8',
                borderRadius: 4
            }]
        },
        options: {
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        drawBorder: false
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Order Status Chart
    const orderStatusColors = getDistributedColors(5);
    initializeChart('orderStatusChart', 'orderStatusChartLoading', {
        type: 'doughnut',
        data: {
            labels: {!! json_encode($charts['order_status']['labels']) !!},
            datasets: [{
                data: {!! json_encode($charts['order_status']['data']) !!},
                backgroundColor: orderStatusColors
            }]
        },
        options: {
            cutout: '70%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true
                    }
                }
            }
        }
    });

    // Top Products Chart
    initializeChart('topProductsChart', 'topProductsChartLoading', {
        type: 'bar',
        data: {
            labels: {!! json_encode($charts['top_products']['labels']) !!},
            datasets: [{
                label: 'Units Sold',
                data: {!! json_encode($charts['top_products']['data']) !!},
                backgroundColor: '#159abef2',
                borderRadius: 4
            }]
        },
        options: {
            indexAxis: 'y',
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                x: {
                    beginAtZero: true,
                    grid: {
                        drawBorder: false
                    }
                },
                y: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Payment Methods Chart - Get dynamic colors based on number of methods
    const paymentLabels = {!! json_encode($charts['payment_methods']['labels']) !!};
    const paymentColors = getDistributedColors(paymentLabels.length);
    
    initializeChart('paymentMethodsChart', 'paymentMethodsChartLoading', {
        type: 'pie',
        data: {
            labels: paymentLabels,
            datasets: [{
                data: {!! json_encode($charts['payment_methods']['data']) !!},
                backgroundColor: paymentColors
            }]
        },
        options: {
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let label = context.label || '';
                            let value = context.parsed || 0;
                            let total = context.dataset.data.reduce((a, b) => a + b, 0);
                            let percentage = ((value / total) * 100).toFixed(1);
                            return `${label}: ${value} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
});</script>
@endsection