// Second Navbar JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Category toggler functionality - now opens the sidebar
    const categoryToggler = document.getElementById('categoryToggler');
    const sidebar = document.querySelector('.mn-sidebar');
    const sidebarOverlay = document.querySelector('.mn-sidebar-overlay');
    
    if (categoryToggler && sidebar) {
        // Toggle sidebar visibility when clicking the button
        categoryToggler.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            // Toggle active class on the button
            this.classList.toggle('active');
            
            // Toggle sidebar visibility
            if (sidebar.classList.contains('sidebar-hide')) {
                sidebar.classList.remove('sidebar-hide');
                if (sidebarOverlay) {
                    sidebarOverlay.style.display = 'block';
                }
                document.body.classList.add('sidebar-open');
            } else {
                sidebar.classList.add('sidebar-hide');
                if (sidebarOverlay) {
                    sidebarOverlay.style.display = 'none';
                }
                document.body.classList.remove('sidebar-open');
            }
        });
        
        // Close sidebar when clicking on overlay
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', function() {
                sidebar.classList.add('sidebar-hide');
                sidebarOverlay.style.display = 'none';
                document.body.classList.remove('sidebar-open');
                categoryToggler.classList.remove('active');
            });
        }
    }
    
    // Also handle the sidebar All Categories button
    const allCategoriesBtn = document.getElementById('allCategoriesBtn');
    if (allCategoriesBtn) {
        allCategoriesBtn.style.backgroundColor = '#159abe';
    }
});
