<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Drop department column from category_groups if it exists
        if (Schema::hasColumn('category_groups', 'department')) {
            Schema::table('category_groups', function (Blueprint $table) {
                $table->dropColumn('department');
            });
        }

        // Drop medical column from customizations if it exists
        if (Schema::hasColumn('customizations', 'medical')) {
            Schema::table('customizations', function (Blueprint $table) {
                $table->dropColumn('medical');
            });
        }
    }

    public function down(): void
    {
        // Restore the columns for rollback safety
        if (!Schema::hasColumn('category_groups', 'department')) {
            Schema::table('category_groups', function (Blueprint $table) {
                $table->string('department')->nullable();
            });
        }

        if (!Schema::hasColumn('customizations', 'medical')) {
            Schema::table('customizations', function (Blueprint $table) {
                $table->json('medical')->nullable();
            });
        }
    }
};



