<?php

namespace App\Providers;

use App\Models\Faq;
use App\Models\Pages;
use App\Models\Order;
use App\Models\Category;
use App\Models\Setting;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
	/**
	 * Register any application services.
	 */
	public function register(): void
	{
		//
	}

	/**
	 * Bootstrap any application services.
	 */
	public function boot(): void
	{
		// Make settings available globally (all routes/controllers/views)
		$settingsGlobal = null;
		if (Schema::hasTable('settings')) {
			$settingsGlobal = Setting::singleton();
			Config::set('site.settings', $settingsGlobal->toArray());
		}
		View::share('appSettings', $settingsGlobal);

		// Share order counts with admin layout
		View::composer('admin_base', function ($view) {
			$orderCounts = [
				'pending' => Order::where('order_status', Order::STATUS_PENDING)->count(),
				'processing' => Order::where('order_status', Order::STATUS_PROCESSING)->count(),
				'shipped' => Order::where('order_status', Order::STATUS_SHIPPED)->count(),
			];
			
			$view->with('orderCounts', $orderCounts);
		});

        // Share categories (flat) with all views
        View::composer('*', function ($view) {
            // Get all root categories for sidebar
            $allRootCategories = Category::whereNull('parent_id')
                ->with(['children' => function($q){ $q->orderBy('name'); }])
                ->orderBy('name')
                ->get();
                
            // Get all categories (both parent and subcategories)
            $allCategories = Category::all();
                
            // Select 6 random categories from all categories
            $topCategories = $allCategories->shuffle()->take(6);
            
            $view->with('topCategories', $topCategories);
            $view->with('allCategories', $allRootCategories);
        });

		// Share additional data with non-admin views
        View::composer(['general.*', 'user.*', 'auth.*', 'blog.*', 'product*'], function ($view) {
			$pages = Pages::all();
			$faqs = Faq::all();
			
            $view->with([
                'pages' => $pages,
                'faqs' => $faqs,
            ]);
		});
	}
}