<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Carbon\Carbon;

class Blogs extends Model
{
    protected $fillable = [
        'user_id',
        'thumbnail',
        'title',
        'slug',
        'content',
        'tags'
    ];
    
    protected $casts = [
        'tags' => 'array'
    ];
    
    protected static function boot()
    {
        parent::boot();
        static::creating(function ($blog) {
            $baseSlug = Str::slug($blog->title);
            $date = Carbon::now()->format('d-m-Y');
            $slug = $baseSlug . '-' . $date;            
            $count = static::where('slug', 'LIKE', $slug . '%')->count();            
            if ($count > 0) {
                $slug .= '-' . ($count + 1);
            }            
            $blog->slug = $slug;
        });
    }

    public function author()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function comments()
    {
        return $this->hasMany(BlogComment::class, 'blog_id');
    }

    public function reactions()
    {
        return $this->hasMany(BlogReaction::class, 'blog_id');
    }

    public function count_likes()
    {
        return $this->reactions()->where('reaction_type', 'like')->count();
    }

    public function count_dislikes()
    {
        return $this->reactions()->where('reaction_type', 'dislike')->count();
    }
}