<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductVariationResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'unit' => [
                'type' => $this->unit_type,
                'value' => $this->unit_value,
            ],
            'price' => [
                'regular' => (int) $this->regular_price,
                'sale' => (int) $this->sale_price,
            ],
            'in_stock' => (int) $this->in_stock,
            'stock_status' => $this->stock_status(),
            'default' => (bool) $this->default,
        ];
    }
}





