<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Cookie;

class Require2FA
{
    public function handle(Request $request, Closure $next)
    {
        $user = auth()->user();

        // Skip 2FA check if user hasn't enabled it
        if (!$user || !$user->has_two_factor_enabled()) {
            return $next($request);
        }

        // Allow logout requests to bypass 2FA
        if ($request->is('logout') || $request->route()->named('logout')) {
            return $next($request);
        }

        // Skip 2FA check for the verification routes themselves
        if ($request->is('security/2fa/verify*')) {
            return $next($request);
        }

        // Check if user has verified 2FA in current session or has a valid remember cookie
        if (Session::has('2fa_verified') || $request->cookie('remember_2fa')) {
            // If only in session but not in cookie, set the cookie for persistence
            if (Session::has('2fa_verified') && !$request->cookie('remember_2fa')) {
                Cookie::queue('remember_2fa', true, 43200); // 30 days (60*24*30)
            }
            return $next($request);
        }

        return redirect()->route('security.2fa.verify');
    }
} 