<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use Illuminate\Http\Request;

class FaqController extends Controller
{
    public function index()
    {
        $faqs = Faq::all();
        return view('admin.pages.faqs', compact('faqs'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'question' => 'required|string|max:255',
            'answer' => 'required|string'
        ]);

        Faq::create($request->all());
        return response()->json(['success' => 'FAQ created successfully.']);
    }

    public function update(Request $request, Faq $faq)
    {
        $request->validate([
            'question' => 'required|string|max:255',
            'answer' => 'required|string'
        ]);

        $faq->update($request->all());
        return response()->json(['success' => 'FAQ updated successfully.']);
    }

    public function destroy(Faq $faq)
    {
        $faq->delete();
        return response()->json(['success' => 'FAQ deleted successfully.']);
    }
} 