<?php session_start();
include('../inc/dbcon.php');
include('../inc/functions.php');
if (isset($_SESSION["axeslogin"]) && $_SESSION["axeslogin"] == true) {
    get_pagesecurity('10', 'creates', 'R');
    $_SESSION['cuPages'] = 'dps_dpscreate.php';
    $cuPage = 'dps_dpscreate.php';
    $aid = $_SESSION['uid'];
    $brid = $_SESSION['abrid'];
} else {
    header('Location:../index.php');
    exit;
}
$mhead = 'dpsins';
$menuh = 'DPS';
$phead = 'dpscreate';
$page = 'DPS Create';
$dtnow = date("Y-m-d h:i:s", time());
?>

<?php
if (isset($_POST['save_dps'])) {
    $mid = remove_junk(escape($_POST['mid']));
    $code = get_genid('DP', 'DPS', 'P');
    $installment_type = remove_junk(escape($_POST['installment_type']));
    $dps_duration = remove_junk(escape($_POST['dps_duration']));
    $dps_type = remove_junk(escape($_POST['dps_type']));
    $dps_amount = remove_junk(escape($_POST['dps_amount']));
    $profit_per = remove_junk(escape($_POST['profit_per']));
    $total_installment = remove_junk(escape($_POST['total_installment']));

    $profile_with_dps_amount = remove_junk(escape($_POST['profile_with_dps_amount']));
    $per_installment_amount = remove_junk(escape($_POST['per_installment_amount']));
    $description = remove_junk(escape($_POST['description']));
    $status = 0;

    if (isset($_POST['mid'])) {
        $ducode = mysqli_query($con, "SELECT * FROM tbl_dps WHERE mid = '$mid' AND status= '0'");
    }

    if ($ducode->num_rows > 0) {
        save_msg('i', 'Alrady Exits A DPS! Plz Close it Frist');
        echo "<script>window.location='dps_dpscreate.php'</script>";
    } else {
        $sql = "INSERT INTO tbl_dps(mid,code,installment_type,dps_duration,dps_type,dps_amount,profit_per,total_installment,profile_with_dps_amount,per_installment_amount,description,status,uid,date)
    VALUES ($mid,'$code','$installment_type','$dps_duration','$dps_type','$dps_amount','$profit_per','$total_installment','$profile_with_dps_amount','$per_installment_amount','$description','$status','$aid','$dtnow')";
        $result = mysqli_query($con, $sql) or die(mysqli_error($con));
        $efid = mysqli_affected_rows($con);
        if ($efid > 0) {
            $act = remove_junk(escape('DPS name: ' . $code));
            write_activity($aid, 'DPS', 'New DPS has been Added', $act);
            save_msg('s', 'Data Successfully Saved!');
        } else {
            save_msg('w', 'Data Fail to Saved!');
        }
        echo "<script>window.location='dps_dpscreate.php'</script>";
    }
}
?>
<?php
include('../layout/head.php');
include('../layout/header.php');
include('../layout/side_nav.php');
?>
<div class="content-wrapper">
    <?php include('../layout/page_head.php'); ?>
    <!-- Main content -->
    <section class="content">

        <div class="row">
            <div class="col-md-9">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">Add New DPS</h3>
                    </div>
                    <div class="box-body">
                        <?php echo display_msg(); ?>
                        <form action="dps_dpscreate.php" onsubmit="return validate()" enctype="multipart/form-data" method="post" accept-charset="utf-8">
                            <div class="col-md-12 popup_details_div">
                                <div class="col-md-1"></div>
                                <div class="col-md-10">
                                    <div class="col-md-12">

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Select Member</label>
                                                    <select class="form-control select2" name="mid" id="mid" required>
                                                        <option value="">-Select One-</option>
                                                        <?php
                                                        $querys = mysqli_query($con, "SELECT * FROM tbl_customer ORDER BY name ASC") or die(mysqli_error($con));
                                                        while ($rows = mysqli_fetch_array($querys)) {
                                                        ?>
                                                            <option value="<?php echo $rows['id']; ?>"><?php echo $rows['code'] . '-' . $rows['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Installment Type</label>
                                                    <select class="form-control select2" name="installment_type" id="installment_type" onchange="total_count()" required>
                                                        <option>Select One</option>
                                                        <option value="1">Weekly</option>
                                                        <option value="2">Monthly</option>
                                                        <option value="3">Daily</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>DPS Duration</label>
                                                    <select class="form-control select2" name="dps_duration" id="dps_duration" onchange="total_count()" required>
                                                        <optgroup label="Yearly">
                                                            <option value="12">1 Year</option>
                                                            <option value="24">2 Year</option>
                                                            <option value="36">3 Year</option>
                                                            <option value="48">4 Year</option>
                                                            <option value="60">5 Year</option>
                                                            <option value="72">6 Year</option>
                                                            <option value="84">7 Year</option>
                                                            <option value="96">8 Year</option>
                                                            <option value="108">9 Year</option>
                                                            <option value="120">10 Year</option>
                                                            <option value="132">11 Year</option>
                                                            <option value="144">12 Year</option>
                                                            <option value="156">13 Year</option>
                                                            <option value="168">14 Year</option>
                                                        </optgroup>
                                                        <optgroup label="Monthly">
                                                            <option value="1">1 Month</option>
                                                            <option value="2">2 Month</option>
                                                            <option value="3">3 Month</option>
                                                            <option value="4">4 Month</option>
                                                            <option value="5">5 Month</option>
                                                            <option value="6">6 Month</option>
                                                            <option value="7">7 Month</option>
                                                            <option value="8">8 Month</option>
                                                            <option value="9">9 Month</option>
                                                            <option value="10">10 Month</option>
                                                            <option value="11">11 Month</option>
                                                        </optgroup>

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>DPS Type</label>
                                                    <select class="form-control select2" name="dps_type" id="dps_type">
                                                        <option value="General">General</option>
                                                        <option value="Small">Small</option>
                                                        <option value="Others">Others</option>
                                                    </select>
                                                </div>
                                            </div>
                                           
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>DPS Amount</label>
                                                    <input type="number" name="dps_amount" maxlength="18" value="" onchange="total_count()" id="dps_original_amount" class="form-control" placeholder="e.g. 5000000000" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Profit Percentange</label>
                                                    <input type="text" name="profit_per" maxlength="18" value="" onchange="total_count()" id="dps_profit_per" class="form-control" placeholder="e.g. 10%" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                           
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Profit With DPS Amount</label>
                                                    <input type="text" name="profile_with_dps_amount" maxlength="20" onchange="total_count()" id="dps_profitwith_amount" class="form-control" onkeypress="return isNumberKey(event)" placeholder="e.g. 350000.00" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Total Installment</label>
                                                    <input type="text" name="total_installment" maxlength="3" onchange="total_count()" value="0" id="total_installment" class="form-control" onkeypress="return isNumberKey(event)" placeholder="e.g. 127" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Per Installment Amount</label>
                                                    <input type="text" name="per_installment_amount" onchange="total_count()" maxlength="3" value="0" id="dps_payamount" class="form-control" onkeypress="return isNumberKey(event)" placeholder="e.g. 127" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                           
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>DPS Description</label>
                                                    <textarea class="form-control" name="description" id="description" maxlength="200" rows="4" placeholder="DPS Description"></textarea>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <div class="col-md-1"></div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12 nopadding widgets_area"></div>
                            <div class="row" style="margin-top: 15px">
                                <div class="col-md-8 ">
                                </div>
                                <div class="col-md-4 text-right">
                                    <input type="submit" name="save_dps" id="submit" class="btn btn-flat bg-purple btn-sm" value="Save" /> <a href="dps_dpslist.php" class="btn btn-flat bg-gray  ">Close</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-solid">
                            <div class="box-header">
                                <h3 class="box-title">History </h3>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <?php if ($_SESSION['access'] == '1') {
                                    echo read_activity($aid, 'DPS', 'A');
                                } else {
                                    echo read_activity($aid, 'DPS', 'U');
                                } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('../layout/quick.php'); ?>
    </section>
    <!-- /.main content -->
</div>

<?php
include('../layout/footer.php');
?>
<!-- page script -->
<script type="text/javascript">
    function total_count() {


        var dps_duration = $('#dps_duration').val();
        var duration = parseFloat(dps_duration);
        var dps_original_amount = $('#dps_original_amount').val();
        var dps_profit_per = $('#dps_profit_per').val();
        var dps_profit_amount = (parseFloat(dps_original_amount) * (parseFloat(dps_profit_per) / 100)) * parseFloat(duration);
        var total = parseFloat(dps_original_amount) + parseFloat(dps_profit_amount);
        $('#dps_profitwith_amount').val(total);

        var installment_type = $('#installment_type').val();
        var dps_duration = $('#dps_duration').val();
        if (installment_type == 1) {
            var total_kisti = parseFloat(dps_duration) * 4;
        } else if (installment_type == 2) {
            var total_kisti = parseFloat(dps_duration);
        } else if (installment_type == 3) {
            var total_kisti = parseFloat(dps_duration) * 30;

        }

        $('#total_installment').val(total_kisti);
        var totalpay = parseFloat(total) / parseFloat(total_kisti);
        $('#dps_payamount').val(totalpay);
    }



    $(document).ready(function() {
        var member_id = new LiveValidation('member_id');
        member_id.add(Validate.Presence);
        var cnumber = new LiveValidation('cnumber');
        cnumber.add(Validate.Presence);
        var address = new LiveValidation('address');
        address.add(Validate.Presence);
        var cemail = new LiveValidation('cemail');
        cemail.add(Validate.Email);

        var climit = new LiveValidation('climit');
        climit.add(Validate.Presence);
        climit.add(Validate.Numericality, {
            minimum: 0,
            onlyInteger: true
        });
        var rank = new LiveValidation('rank');
        rank.add(Validate.Presence);
        rank.add(Validate.Numericality, {
            minimum: 0,
            onlyInteger: true
        });
    });
</script>
<!-- /page script -->

</html>