<?php
ob_end_clean();
require('../fpdf/fpdf.php');
session_start();
include('../inc/dbcon.php');
include('../inc/functions.php');
include('../inc/invfunctions.php');

if(!isset($_SESSION["axeslogin"]) || $_SESSION["axeslogin"] != true){
    header('Location:../index.php');
    exit;
}

// if(!isset($_POST['print'])) {
//     die("No invoice selected.");
// }

$invid = 2;
$sql = "SELECT * FROM tbl_recvoucher WHERE id='".$invid."' LIMIT 1";
$query = mysqli_query($con, $sql) or die(mysqli_error($con));
$rowadd = mysqli_fetch_array($query);
$id = $rowadd['id'];

$user = get_fild_data('tbl_user', $rowadd['uid'], 'name');

// Create PDF instance
$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();

// Title
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, 'RECEIPT VOUCHER', 0, 1, 'C');
$pdf->Ln(5);

// Company info
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 6, get_cominfo('1', 'name'), 0, 1, 'C');
$pdf->Ln(5);

// Receipt details
$pdf->SetFont('Arial', '', 11);
$pdf->Cell(95, 7, 'Receipt No: '.$rowadd['invno'], 0, 0);
$pdf->Cell(95, 7, 'Date: '.date("d M Y", strtotime($rowadd['apdate'])), 0, 1);
$pdf->Ln(5);

// Table header
$pdf->SetFont('Arial', 'B', 10);
$pdf->SetFillColor(230,230,230);
$pdf->Cell(10, 8, 'No', 1, 0, 'C', true);
$pdf->Cell(50, 8, 'Head of Accounts', 1, 0, 'C', true);
$pdf->Cell(25, 8, 'Mode', 1, 0, 'C', true);
$pdf->Cell(25, 8, 'Cheque', 1, 0, 'C', true);
$pdf->Cell(25, 8, 'Date', 1, 0, 'C', true);
$pdf->Cell(30, 8, 'Amount', 1, 0, 'C', true);
$pdf->Cell(25, 8, 'Reference', 1, 1, 'C', true);

// Table data
$pdf->SetFont('Arial', '', 10);

$sql="SELECT (CONVERT(CONCAT(tbl_trarecord.cty,tbl_trarecord.cid) USING utf8) COLLATE utf8_general_ci) AS id,
did,dty,amo,chkno,chkdt,ref,refinv 
FROM tbl_trarecord 
WHERE invno='".$rowadd['invno']."'";
$querys = mysqli_query($con, $sql) or die(mysqli_error($con));

$count = 1;
$total = 0;

while ($rows = mysqli_fetch_array($querys)) {
    $ledger = get_fild_data('tbl_ledger', $rows['id'], 'ledger');
    $mode = get_namebytype($rows['dty'], 'N', $rows['did']);
    $chkno = $rows['chkno'];
    $chkdt = (strlen($chkno)>0) ? date("d M Y", strtotime($rows['chkdt'])) : '';
    $amount = numtolocal($rows['amo'],'');
    $ref = $rows['ref'].' '.$rows['refinv'];

    $pdf->Cell(10, 8, $count, 1, 0, 'C');
    $pdf->Cell(50, 8, $ledger, 1, 0);
    $pdf->Cell(25, 8, $mode, 1, 0, 'C');
    $pdf->Cell(25, 8, $chkno, 1, 0, 'C');
    $pdf->Cell(25, 8, $chkdt, 1, 0, 'C');
    $pdf->Cell(30, 8, $amount, 1, 0, 'R');
    $pdf->Cell(25, 8, $ref, 1, 1, 'C');
    $total += $rows['amo'];
    $count++;
}

// Total row
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(135, 8, 'Total', 1, 0, 'R');
$pdf->Cell(30, 8, numtolocal($total,''), 1, 0, 'R');
$pdf->Cell(25, 8, '', 1, 1, 'C');

// Amount in words
$pdf->Ln(5);
$pdf->SetFont('Arial', '', 10);
$pdf->MultiCell(0, 6, 'In Words: '.conToword_local($total).'.');

// Note
$pdf->Ln(3);
$pdf->MultiCell(0, 6, 'Note: '.$rowadd['note']);

// Footer signature
$pdf->Ln(20);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(90, 6, 'Prepared by: '.$user, 0, 0);
$pdf->Cell(90, 6, 'Authorized Signature: ______________________', 0, 1, 'R');

$pdf->Ln(10);
$pdf->SetFont('Arial', 'I', 9);
$pdf->Cell(0, 6, get_cominfo('1', 'name').' © '.date('Y'), 0, 1, 'C');

// Output PDF
$pdf->Output('I', 'receipt_'.$rowadd['invno'].'.pdf');
exit;
?>
