
<?php $__env->startSection('title'); ?>
Team
<?php $__env->stopSection(); ?>
<?php
    $company = App\Models\Company::first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($company->meta_title); ?>">
    <meta name="description" content="<?php echo e($company->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="og:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($company->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($company->meta_des); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('public')); ?>/<?php echo e($company->logo); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    $teams = App\Models\Team::limit(100);
?>
 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> Our Team <?php else: ?> আমাদের টীম <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Team <?php else: ?> টীম  <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<section class="team-member-section padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-4 col-sm-6 col-12">
                        <div class="team-item-2">
                            <div class="team-inner">
                                <div class="team-thumb">
                                    <img src="<?php echo e(asset('public')); ?>/<?php echo e($team->image); ?>" class="br-5" alt="team-image">
                                </div>
                                <div class="team-content">
                                    <a href="#"><h5><?php if(session()->get('lang') == 'en'): ?> <?php echo e($team->name); ?> <?php else: ?> <?php echo e($team->name_bn); ?>  <?php endif; ?></h5></a>
                                    <p><?php if(session()->get('lang') == 'en'): ?> <?php echo e($team->designation); ?> <?php else: ?> <?php echo e($team->designation_bn); ?>  <?php endif; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/team/index.blade.php ENDPATH**/ ?>