
<?php $__env->startSection('title'); ?>
Product Category
<?php $__env->stopSection(); ?>

<?php
    $category = App\Models\Category::where('slug',explode('category/',request()->path())[1])->first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($category->name); ?>">
    <meta name="description" content="<?php echo e($category->description); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($category->name); ?>">
    <meta property="og:description" content="<?php echo e($category->description); ?>">
    <meta property="og:image" content="<?php echo e(asset('')); ?><?php echo e($category->image); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($category->name); ?>">
    <meta property="twitter:description" content="<?php echo e($category->description); ?>">
    <meta property="twitter:image" content="<?php echo e(asset('')); ?><?php echo e($category->image); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> <?php echo e($category->name); ?> <?php else: ?> <?php echo e($category->name_bn); ?> <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Product <?php else: ?> পণ্য <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- shop page Section Start Here -->
<div class="shop-page padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-12 col-12">
                    <article>
                        <div class="shop-product-wrap grids row justify-content-center">
                            <?php $__currentLoopData = $category->product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="product-item">
                                        <div class="product-thumb">
                                            <img src="<?php echo e(asset('')); ?><?php echo e($product->image); ?>" alt="shope">
                                            <div class="product-action-link">
                                                <a href="/product/<?php echo e($product->slug); ?>"><i class="icofont-eye"></i></a>
                                            </div>
                                        </div>
                                        <div class="product-content">
                                            <h6><a href="/product/<?php echo e($product->slug); ?>"><?php if(session()->get('lang') == 'en'): ?> <?php echo e($product->name); ?> <?php else: ?> <?php echo e($product->name_bn); ?>  <?php endif; ?></a></h6>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- shop page Section ENding Here -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/product/index.blade.php ENDPATH**/ ?>