
<?php $__env->startSection('title'); ?>
Sister Concern
<?php $__env->stopSection(); ?>
<?php
    $concerns = App\Models\SisterConcern::all();
    $branchInfo = App\Models\BranchIntro::first();
?>
<?php $__env->startSection('meta'); ?>
    <meta name="title" content="<?php echo e($branchInfo->meta_title); ?>">
    <meta name="description" content="<?php echo e($branchInfo->meta_des); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($branchInfo->meta_title); ?>">
    <meta property="og:description" content="<?php echo e($branchInfo->meta_des); ?>">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo e(url()->current()); ?>">
    <meta property="twitter:title" content="<?php echo e($branchInfo->meta_title); ?>">
    <meta property="twitter:description" content="<?php echo e($branchInfo->meta_des); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title"><?php if(session()->get('lang') == 'en'): ?> Our Sister Concern <?php else: ?> আমাদের সহপ্রতিষ্ঠান <?php endif; ?></h4>
            <ul class="agri-ul">
                <li><a href="/"><?php if(session()->get('lang') == 'en'): ?> Home <?php else: ?> হোম <?php endif; ?></a></li>
                <li><a class="active"><?php if(session()->get('lang') == 'en'): ?> Our Sister Concern <?php else: ?> আমাদের সহপ্রতিষ্ঠান <?php endif; ?></a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- Service Section Start Here -->
<section class="service-section padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $concerns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $concern): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6 col-12">
                    <div class="lab-item">
                        <div class="lab-inner">
                            <div class="lab-content">
                                <a href="<?php echo e($concern->link); ?>" target="_blank"><img src="<?php echo e(asset('')); ?><?php echo e($concern->logo); ?>" alt="sister-concern"></a>
                                <h5 class="mt-2"><a href="sister-concern/<?php echo e($concern->slug); ?>"><?php if(session()->get('lang') == 'en'): ?> <?php echo e($concern->company_name); ?> <?php else: ?> <?php echo e($concern->company_name_bn); ?>  <?php endif; ?></a></h5>
                                <p><strong>Call:</strong> <?php if(session()->get('lang') == 'en'): ?> <?php echo e($concern->phone); ?> <?php else: ?> <?php echo e($concern->phone_bn); ?>  <?php endif; ?></p>
                                <p><strong>E-Mail:</strong> <?php echo e($concern->email); ?> </p>
                                <p><strong>Address:</strong> <?php if(session()->get('lang') == 'en'): ?> <?php echo e($concern->address); ?> <?php else: ?> <?php echo e($concern->address_bn); ?>  <?php endif; ?> </p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\ewclold\resources\views/frontend/pages/sister_concern/index.blade.php ENDPATH**/ ?>