@extends('frontend.master')
@section('title')
Team
@endsection
@php
    $company = App\Models\Company::first();
@endphp
@section('meta')
    <meta name="title" content="{{$company->meta_title}}">
    <meta name="description" content="{{$company->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$company->meta_title}}">
    <meta property="og:description" content="{{$company->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$company->logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$company->meta_title}}">
    <meta property="twitter:description" content="{{$company->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$company->logo}}">

@endsection
@section('content')
@php
    $teams = App\Models\Team::limit(100);
@endphp
 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Our Team @else আমাদের টীম @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Team @else টীম  @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<section class="team-member-section padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                @foreach ($teams as $team)
                    <div class="col-xl-3 col-lg-4 col-sm-6 col-12">
                        <div class="team-item-2">
                            <div class="team-inner">
                                <div class="team-thumb">
                                    <img src="{{asset('public')}}/{{$team->image}}" class="br-5" alt="team-image">
                                </div>
                                <div class="team-content">
                                    <a href="#"><h5>@if(session()->get('lang') == 'en') {{$team->name}} @else {{$team->name_bn}}  @endif</h5></a>
                                    <p>@if(session()->get('lang') == 'en') {{$team->designation}} @else {{$team->designation_bn}}  @endif</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endsection