@extends('frontend.master')
@section('title')
Sister Concern Details
@endsection
@php
    $concern = App\Models\SisterConcern::where('slug',explode('sister-concern/',request()->path())[1])->first();
@endphp
@section('meta')
    <meta name="title" content="{{$concern->company_name}}">
    <meta name="description" content="{{$concern->company_name}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$concern->company_name}}">
    <meta property="og:description" content="{{$concern->company_name}}">
    <meta property="og:image" content="{{asset('')}}{{$concern->logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$concern->company_name}}">
    <meta property="twitter:description" content="{{$concern->company_name}}">
    <meta property="twitter:image" content="{{asset('')}}{{$concern->logo}}">

@endsection
@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') {{$concern->company_name}} @else {{$concern->company_name_bn}} @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en')  Our Sister Concern @else আমাদের সহপ্রতিষ্ঠান  @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="concern-section concern-single padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-12 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-thumb">
                                    <img src="{{asset('')}}{{$concern->logo}}" width="150" alt="concern" class="br-5">
                                </div>
                                <div class="post-content">
                                    <h4>@if(session()->get('lang') == 'en') {{$concern->company_name}} @else {{$concern->company_name_bn}} @endif</h4>
                                    <div class="meta-post">
                                        <p><strong>Call:</strong> @if(session()->get('lang') == 'en') {{$concern->phone}} @else {{$concern->phone_bn}}  @endif</p>
                                        <p><strong>E-Mail:</strong> {{$concern->email}} </p>
                                        <p><strong>Address:</strong> @if(session()->get('lang') == 'en') {{$concern->address}} @else {{$concern->address_bn}}  @endif </p>
                                    </div>
                                    @if(session()->get('lang') == 'en') {!! $concern->description !!} @else {!! $concern->description_bn !!} @endif
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection