@extends('frontend.master')
@section('title') Home @endsection

@section('meta')
    @php
        $company = App\Models\Company::first();
    @endphp
    <meta name="title" content="{{$company->meta_title}}">
    <meta name="description" content="{{$company->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$company->meta_title}}">
    <meta property="og:description" content="{{$company->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$company->logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$company->meta_title}}">
    <meta property="twitter:description" content="{{$company->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$company->logo}}">

@endsection

@section('head')
    <style>
        .agricul-farm-section .section-wrapper .farm-left .agricul-farm-animate .farm-line:nth-child(1) {
            top: 48%;
            right: 58%;
        }
    </style>
@endsection
@section('header-class') transparent-header @endsection

@section('content')
@include('frontend.pages.home.slider')

<section class="feature-section padding-tb">
    {{-- <div class="shape-feature d-none d-xl-block">
        <img src="{{asset('public/frontend')}}/assets/images/feature/shape/01.png" alt="feature-thumb" class="shape-1">
        <img src="{{asset('public/frontend')}}/assets/images/feature/shape/02.png" alt="feature-thumb" class="shape-2">
        <img src="{{asset('public/frontend')}}/assets/images/feature/shape/03.png" alt="feature-thumb" class="shape-3">
    </div> --}}
    <div class="container">
        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">
            <h3>@if(session()->get('lang') == 'en') Agriculture Product @else কৃষি পণ্য @endif</h3>
        </div>
        <div class="section-wrapper">
            <div class="row">
                @foreach (App\Models\Category::limit(6) as $category)
                    <div class="col-xl-4 col-md-6 col-12 wow fadeInUp" data-wow-delay="0.4s">
                        <div class="feature-item">
                            <div class="feature-inner">
                                <div class="feature-thumb">
                                    <img src="{{$category->image}}" alt="feature">
                                </div>
                                <div class="feature-content">
                                    <a href="/category/{{$category->slug}}"><h5>@if(session()->get('lang') == 'en') {{$category->name}} @else {{$category->name_bn}} @endif</h5></a>
                                    {{-- <p>@if(session()->get('lang') == 'en') {{ Str::limit($category->description, 50) }} @else {{ Str::limit($category->description_bn, 50) }} @endif</p> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
<!-- Feature Secton ending Here -->

<!-- about section start here -->
<section class="about-us bg_img_1 bg_img padding-tb">
    @php
        $about = App\Models\AboutUs::first();
    @endphp
    <div class="shape-about d-none d-xl-block">
        <img src="{{asset('public')}}//assets/images/about/02.png" alt="abs-thumb">
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-12">
                <div class="about-thumb ml-about-thumb wow fadeInUp" data-wow-delay="0.4s">
                    <img src="{{asset('public')}}/{{$about->image}}" alt="about-thumb" class="br-5">
                </div>
            </div>
            <div class="col-lg-6 col-12">
                <div class="section-header text-start wow fadeInUp" data-wow-delay="0.3s">
                    <h3>@if(session()->get('lang') == 'en') {{$about->title}} @else {{$about->title_bn}} @endif</h3>
                    <p>@if(session()->get('lang') == 'en') {!! Str::limit($about->description, 3000) !!} @else {!! Str::limit($about->description_bn, 3000) !!} @endif</p>
                </div>
                <div class="text-start wow fadeInUp @if(session()->get('lang') == 'en') mt-5 @else mt1 @endif" data-wow-delay="0.6s">
                    <a href="/about-us" class="lab-btn"><span>@if(session()->get('lang') == 'en') About Us @else আমাদের সম্পর্কে @endif</span></a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- about section ending here -->



<!-- agricul farm section start here -->
<section class="agricul-farm-section padding-tb bg_img_1 bg_img ">
    @php
        $branchInfo = App\Models\BranchIntro::first();
    @endphp
    <div class="container">
        <div class="section-wrapper">
            <div class="row">
                <div class="col-lg-7 col-12 wow fadeInUp" data-wow-delay="0.3s">
                    <div class="farm-left">
                        <div class="agricul-farm-thumb">
                            <img src="{{asset('public/frontend')}}/assets/images/farm/depotmap.png" alt="agricul-farm">
                        </div>
                        <div class="agricul-farm-animate">
                            <div class="farm-line">
                                <div class="lab-tooltip"><p>@if(session()->get('lang') == 'en') Bangladesh @else প্রধান কার্যালয় @endif</p></div>
                                <span class="pluse_1"></span><span class="pluse_2"></span>
                            </div>
                        </div>
                        
                      
                    </div>
                </div>
                <div class="col-lg-5 col-12 wow fadeInUp" data-wow-delay="0.4s">
                    <div class="farm-right" style="margin-top:150px;">
                        <div class="section-header text-center text-lg-start">
                            <h3>@if(session()->get('lang') == 'en') {{$branchInfo->title}} @else {{$branchInfo->title_bn}} @endif</h3>
                            <p>@if(session()->get('lang') == 'en') {!! $branchInfo->description !!} @else {!! $branchInfo->description_bn !!} @endif</p>
                            <a href="/depot" class="lab-btn"><span>@if(session()->get('lang') == 'en') Get All Branch @else  সকল ডিপো @endif</span></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- agricul farm section ending here -->

<!-- team member section start here -->
<section class="team-member-section padding-tb">
    <div class="container">
        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">
            <h3>@if(session()->get('lang') == 'en') Our Team @else আমাদের টিম @endif </h3>
        </div>
        <div class="section-wrapper">
            <div class="row">
                @foreach (App\Models\Team::limit(4) as $team)
                    <div class="col-xl-3 col-lg-4 col-sm-6 col-12 wow fadeInUp" data-wow-delay="0.4s" >
                        <div class="team-item">
                            <div class="team-inner">
                                <div class="team-thumb">
                                    <img src="{{asset('public')}}/{{$team->image}}" alt="team-image">
                                </div>
                                <div class="team-content">
                                    <a href="#"><h6>@if(session()->get('lang') == 'en') {{$team->name}} @else {{$team->name_bn}} @endif</h6></a>
                                    <p>@if(session()->get('lang') == 'en') {{$team->designation}} @else {{$team->designation_bn}} @endif</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
<!-- team member section ending here -->

<!-- blog section start here -->
<!--<section class="blog-section padding-tb bg_img_1 bg_img">-->
<!--    <div class="container">-->
<!--        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">-->
<!--            <h3>@if(session()->get('lang') == 'en') Blog @else ব্লগ @endif</h3>-->
<!--        </div>-->
<!--        <div class="section-wrapper">-->
<!--            <div class="row justify-content-center">-->
<!--                @foreach (App\Models\Blog::limit(3) as $blog)-->
<!--                <div class="col-xl-4 col-md-6 col-12 wow fadeInUp" data-wow-delay="0.4s">-->
<!--                    <div class="post-item">-->
<!--                        <div class="post-inner">-->
<!--                            <div class="post-thumb">-->
<!--                                <a href="/blogs/{{$blog->slug}}">-->
<!--                                    <img src="{{asset('public')}}/{{$blog->image}}" alt="blog">-->
<!--                                </a>-->
<!--                                <div class="meta-date">-->
<!--                                    <div class="md-pre">-->
<!--                                        <p>{{ $blog->created_at->format('d') }} {{ $blog->created_at->format('F') }},  {{ $blog->created_at->format('Y') }}</p>-->
<!--                                    </div>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                            <div class="post-content">-->
<!--                                <a href="/blogs/{{$blog->slug}}"><h5>@if(session()->get('lang') == 'en') {{$blog->title}} @else {{$blog->title_bn}} @endif</h5></a>-->
<!--                                <div class="text-btn">-->
<!--                                    <a href="/blogs/{{$blog->slug}}">@if(session()->get('lang') == 'en') Read More @else আরও পড়ুন @endif</a>-->
<!--                                </div>   -->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                </div>-->
<!--                @endforeach-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<!-- sponsor section start here -->
<div class="sponsor-section padding-tb">
    <div class="container">
        <div class="section-header wow fadeInUp" data-wow-delay="0.3s">
            <h3>@if(session()->get('lang') == 'en') Our Sister Concern @else আমাদের সহপ্রতিষ্ঠান @endif</h3>
        </div>
        <div class="section-wrapper wow fadeInUp" data-wow-delay="0.4s">
            <div class="sponsor-slider">
                <div class="swiper-wrapper">
                    @foreach (App\Models\SisterConcern::get() as $concern)
                    <div class="swiper-slide">
                        <div class="sponsor-item">
                            <div class="sponsor-thumb">
                                <a href="{{$concern->link}}" target="_blank"><img src="{{asset('public')}}/{{$concern->logo}}" alt="sister-concern"></a>
                                
                                    <br>
                                    <a href="{{$concern->link}}"><p>@if(session()->get('lang') == 'en') {{$concern->company_name}} @else {{$concern->company_name_bn}} @endif</p></a>
                           
                                
                            </div>
                            
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
<!-- sponsor section ending here -->



<!-- product section start here -->
<!--<section class="product-section padding-tb">-->
<!--    <div class="container">-->
<!--        <div class="section-header wow fadeInUp" data-wow-delay="0.4s">-->
<!--            <h3>@if(session()->get('lang') == 'en') Gallery @else ছবি @endif</h3>-->
<!--        </div>-->
<!--        <div class="section-wrapper wow fadeInUp" data-wow-delay="0.5s">-->
<!--            <div class="grid">-->
<!--                @foreach (App\Models\Gallery::limit(9) as $gallery)-->
<!--                    <div class="product-item fruits">-->
<!--                        <div class="product-inner">-->
<!--                            <div class="product-thumb">-->
<!--                                <img src="{{asset('public')}}/{{$gallery->image}}" alt="product">-->
<!--                            </div>-->
<!--                            <div class="product-content">-->
<!--                                <a href="{{asset('public')}}/{{$gallery->image}}" data-rel="lightcase" class="product-name">@if(session()->get('lang') == 'en') {{$gallery->title}} @else {{$gallery->title_bn}} @endif</a>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                @endforeach-->
<!--            </div>-->
<!--        </div>-->
<!--    </div>-->
<!--</section>-->
<!-- product section ending here -->

@endsection