@extends('frontend.master')
@section('title')
Depot
@endsection
@php
    $branchs = App\Models\Branch::all();
    $branchInfo = App\Models\BranchIntro::first();
@endphp
@section('meta')
    <meta name="title" content="{{$branchInfo->meta_title}}">
    <meta name="description" content="{{$branchInfo->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$branchInfo->meta_title}}">
    <meta property="og:description" content="{{$branchInfo->meta_des}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$branchInfo->meta_title}}">
    <meta property="twitter:description" content="{{$branchInfo->meta_des}}">

@endsection
@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Depot @else ডিপো @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Depot @else ডিপো @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- Service Section Start Here -->
<section class="service-section padding-tb">
    <div class="container">
        <div class="section-header">
            <h3>@if(session()->get('lang') == 'en') {{$branchInfo->title}} @else {{$branchInfo->title_bn}} @endif</h3>
        </div>
        <div class="section-wrapper">
            <div class="row justify-content-center">
                @foreach ($branchs as $branch)
                <div class="col-xl-4 col-md-6 col-12">
                    <div class="lab-item">
                        <div class="lab-inner">
                            <div class="lab-content">
                                <h5>@if(session()->get('lang') == 'en') {{$branch->name}} @else {{$branch->name_bn}}  @endif</h5>
                                <p><strong>@if(session()->get('lang') == 'en') Address: @else ঠিকানা: @endif</strong> @if(session()->get('lang') == 'en') {{$branch->address}} @else {{$branch->address_bn}}  @endif </p>
                                <p><strong>@if(session()->get('lang') == 'en') CALL: @else ফোন :@endif</strong> @if(session()->get('lang') == 'en') {{$branch->phone}} @else {{$branch->phone_bn}}  @endif</p>
                                <p><strong>@if(session()->get('lang') == 'en') E-Mail: @else ইমেল: @endif</strong> {{$branch->email}} </p>
                                
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
@endsection