@extends('frontend.master')
@section('title')
Blog Details
@endsection
@php
    $blog = App\Models\Blog::where('slug',explode('blogs/',request()->path())[1])->first();
@endphp
@section('meta')
    <meta name="title" content="{{$blog->meta_title}}">
    <meta name="description" content="{{$blog->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$blog->meta_title}}">
    <meta property="og:description" content="{{$blog->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$blog->image}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$blog->meta_title}}">
    <meta property="twitter:description" content="{{$blog->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$blog->image}}">

@endsection
@section('content')

 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') {{$blog->title}} @else {{$blog->title_bn}} @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Blog @else ব্লগ @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<div class="blog-section blog-single padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-12 col-12">
                    <article>
                        <div class="post-item-2">
                            <div class="post-inner">
                                <div class="post-thumb">
                                    <img src="{{asset('public')}}/{{$blog->image}}" alt="blog" class="br-5">
                                </div>
                                <div class="post-content">
                                    <h4>@if(session()->get('lang') == 'en') {{$blog->title}} @else {{$blog->title_bn}} @endif</h4>
                                    <div class="meta-post">
                                        <p><span class="post-date">Posted On:<a href="#">{{ $blog->created_at->format('F') }} {{ $blog->created_at->format('d') }}, {{ $blog->created_at->format('Y') }}</a></span></p>
                                    </div>
                                    @if(session()->get('lang') == 'en') {!! $blog->description !!} @else {!! $blog->description_bn !!} @endif
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection