@extends('frontend.master')
@section('title')
Blog
@endsection
@php
    $company = App\Models\Company::first();
@endphp
@section('meta')
    <meta name="title" content="{{$company->meta_title}}">
    <meta name="description" content="{{$company->meta_des}}">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{url()->current()}}">
    <meta property="og:title" content="{{$company->meta_title}}">
    <meta property="og:description" content="{{$company->meta_des}}">
    <meta property="og:image" content="{{asset('public')}}/{{$company->logo}}">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{url()->current()}}">
    <meta property="twitter:title" content="{{$company->meta_title}}">
    <meta property="twitter:description" content="{{$company->meta_des}}">
    <meta property="twitter:image" content="{{asset('public')}}/{{$company->logo}}">

@endsection
@section('content')
@php
    $blogs = App\Models\Blog::limit(12);
@endphp
 <!-- Page Header Section Start Here -->
 <section class="page-header bg_img padding-tb">
    <div class="overlay"></div>
    <div class="container">
        <div class="page-header-content-area">
            <h4 class="ph-title">@if(session()->get('lang') == 'en') Blog @else ব্লগ @endif</h4>
            <ul class="agri-ul">
                <li><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                <li><a class="active">@if(session()->get('lang') == 'en') Blog @else ব্লগ @endif</a></li>
            </ul>
        </div>
    </div>
</section>
<!-- Page Header Section Ending Here -->

<!-- shop page Section Start Here -->
<div class="shop-page padding-tb">
    <div class="container">
        <div class="section-wrapper">
            <div class="row justify-content-center">
                <div class="col-lg-12 col-12">
                    <article>
                        <div class="shop-product-wrap grids row justify-content-center">
                            @foreach ($blogs as $blog)
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="post-item">
                                        <div class="post-inner">
                                            <div class="post-thumb">
                                                <a href="/blogs/{{$blog->slug}}">
                                                    <img src="{{asset('public')}}/{{$blog->image}}" alt="blog">
                                                </a>
                                                <div class="meta-date">
                                                    <div class="md-pre">
                                                        <p>{{ $blog->created_at->format('d') }} {{ $blog->created_at->format('F') }},  {{ $blog->created_at->format('Y') }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="post-content">
                                                <a href="/blogs/{{$blog->slug}}"><h5>@if(session()->get('lang') == 'en') {{$blog->title}} @else {{$blog->title_bn}} @endif</h5></a>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="paginations">
                            <ul class="agri-ul d-flex flex-wrap justify-content-center">
                                @for ($i = 0; $i < App\Models\Blog::page(12); $i++)
                                    <li><a href="/blogs?page={{$i+1}}">{{$i+1}}</a></li>
                                @endfor
                            </ul>
                        </div>
                    </article>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- shop page Section ENding Here -->
@endsection