@php
    $company = App\Models\Company::first();
@endphp
<header class="header-section @yield('header-class') ">
    <div class="header-area">
        <div class="container">
            <nav class="navbar navbar-expand-lg">
                <div class="primary-menu">
                    <div class="logo">
                        <a href="/"><img src="{{asset('public')}}/{{$company->logo}}" alt="logo"></a>
                    </div>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <i class="icofont-navigation-menu"></i>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <div class="main-area">
                            <div class="main-menu">
                                <ul class="agri-ul">
                                    <li class="{{ '/' == request()->path() ? 'active' : '' }}"><a href="/">@if(session()->get('lang') == 'en') Home @else হোম @endif</a></li>
                                    <li class="{{ ('about-us' == request()->path() || 'founder-speech' == request()->path() || 'mission-visions' == request()->path() || 'team' == request()->path() ) ? 'active' : '' }}">
                                        <a href="#">@if(session()->get('lang') == 'en') About @else আমাদের সম্পর্কে @endif</a>
                                        <ul class="agri-ul">
                                            <li><a href="/about-us">@if(session()->get('lang') == 'en') About Us @else আমাদের সম্পর্কে @endif</a></li>
                                            <!--<li><a href="/founder-speech">@if(session()->get('lang') == 'en') Founder Speech @else প্রতিষ্ঠাতা বক্তব্য @endif</a></li>-->
                                            <li><a href="/mission-visions">@if(session()->get('lang') == 'en') Mission & Visions @else মিশন ও ভিশন @endif</a></li>
                                            <li><a href="/team">@if(session()->get('lang') == 'en') Our Team @else আমাদের টীম @endif</a></li>
                                            <li><a href="/sister-concern">@if(session()->get('lang') == 'en') Our Sister Concern @else আমাদের সহপ্রতিষ্ঠান @endif</a></li>
                                        </ul>
                                    </li>
                                    <li class="{{ '/category/*' == request()->path() ? 'active' : '' }}">
                                        <a href="#">@if(session()->get('lang') == 'en') Products @else পণ্য @endif</a>
                                        <ul>
                                            @foreach (App\Models\Category::data() as $category)
                                                <li><a href="/category/{{$category->slug}}"> @if(session()->get('lang') == 'en') {{$category->name}} @else {{$category->name_bn}} @endif</a></li>
                                            @endforeach
                                        </ul>
                                    </li>
                                    <li class="{{ 'depot' == request()->path() ? 'active' : '' }}"><a href="/depot">@if(session()->get('lang') == 'en') Depot @else ডিপো @endif</a></li>
                                    <li class="{{ 'gallery' == request()->path() ? 'active' : '' }}"><a href="/gallery">@if(session()->get('lang') == 'en') Gallery @else ছবি @endif</a></li>
                                    <!--<li class="{{ 'blogs' == request()->path() ? 'active' : '' }}"><a href="/blogs">@if(session()->get('lang') == 'en') Blog @else ব্লগ @endif</a></li>-->
                                    <li class="{{ 'contact-us' == request()->path() ? 'active' : '' }}"><a href="/contact-us">@if(session()->get('lang') == 'en') Contact @else যোগাযোগ @endif</a></li>
                                    <!--<li>-->
                                    <!--    <a href="#">-->
                                    <!--        <i class="icofont-globe"></i>-->
                                    <!--        @if(session()->get('lang') == 'en') English @else বাংলা @endif</a>-->
                                    <!--    <ul class="agri-ul">-->
                                    <!--        <li><a href="/lang/bn">বাংলা</a></li>-->
                                    <!--        <li><a href="/lang/english">English</a></li>-->
                                    <!--    </ul>-->
                                    <!--</li>-->
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
    </div>
</header>