@php
    $company = App\Models\Company::first();
    $about = App\Models\AboutUs::first();
    $socialMedia = App\Models\SocialMedia::first();
@endphp
<footer class="footer-section padding-tb pb-0">
    <div class="container">
        <div class="footer-top">
            <div class="row">
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item">
                        <div class="footer-inner">
                            <div class="footer-logo">
                                <img src="{{asset('public')}}/{{$company->logo}}" alt="footer-logo">
                            </div>
                            <div class="footer-desc">
                                <p>@if(session()->get('lang') == 'en') {!! Str::limit($about->short_description, 250) !!} @else {!! Str::limit($about->short_description_bn, 250) !!} @endif</p>
                            </div>
                            <div class="ht-right">
								<div class="scocial-media">
									<a href="{{$socialMedia->facebook}}" target="_blank" class="facebook"><i class="icofont-facebook"></i></a>
									<a href="{{$socialMedia->twitter}}" target="_blank" class="twitter"><i class="icofont-twitter"></i></a>
									<a href="{{$socialMedia->linked_in}}" target="_blank" class="linkedin"><i class="icofont-linkedin"></i></a>
									<a href="{{$socialMedia->instragram}}" target="_blank" class="instragram"><i class="icofont-vimeo"></i></a>
									<a href="{{$socialMedia->youtube}}" target="_blank" class="youtube"><i class="icofont-youtube"></i></a>
								</div>
							</div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item footer-addtess">
                        <div class="footer-inner">
                            <div class="footer-title">
                                <h5>@if(session()->get('lang') == 'en') Keep In Touch @else যোগাযোগ @endif </h5>
                            </div>
                            <div class="footer-body">
                                <ul class="agri-ul">
                                    <li>
                                        <div class="icon">
                                            <i class="icofont-google-map"></i>
                                        </div>
                                        <div class="detalis">
                                            <p>@if(session()->get('lang') == 'en') {{$company->address}} @else {{$company->address_bn}} @endif</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="icofont-phone"></i>
                                        </div>
                                        <div class="detalis">
                                            <p>@if(session()->get('lang') == 'en') {{$company->phone}} @else {{$company->phone_bn}} @endif</p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon">
                                            <i class="icofont-envelope"></i>
                                        </div>
                                        <div class="detalis">
                                            <p>{{$company->email}}</p>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item footer-addtess">
                        <div class="footer-inner">
                            <div class="footer-title">
                                <h5>@if(session()->get('lang') == 'en') About @else আমাদের সম্পর্কে @endif</a></h5>
                            </div>
                            <div class="footer-body">
                                <ul class="agri-ul">
                                    <li><a href="/about-us">@if(session()->get('lang') == 'en') About Us @else আমাদের সম্পর্কে @endif</a></li>
                                    <li><a href="/founder-speech">@if(session()->get('lang') == 'en') Founder Speech @else প্রতিষ্ঠাতা বক্তব্য @endif</a></li>
                                    <li><a href="/mission-visions">@if(session()->get('lang') == 'en') Mission & Visions @else মিশন ও ভিশন @endif</a></li>
                                    <li><a href="/team">@if(session()->get('lang') == 'en') Our Team @else আমাদের টীম @endif</a></li>
                                    <li><a href="/sister-concern">@if(session()->get('lang') == 'en') Our Sister Concern @else আমাদের সহপ্রতিষ্ঠান @endif</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-12">
                    <div class="footer-item footer-addtess">
                        <div class="footer-inner">
                            <div class="footer-title">
                                <h5>@if(session()->get('lang') == 'en') Products @else পণ্য @endif</h5>
                            </div>
                            <div class="footer-body">
                                <ul class="agri-ul">
                                    @foreach (App\Models\Category::limit(5) as $category)
                                        <li><a href="/category/{{$category->slug}}"> @if(session()->get('lang') == 'en') {{$category->name}} @else {{$category->name_bn}} @endif</a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; {{date('Y')}}<a href="/" target="_blank"><span>@if(session()->get('lang') == 'en') {{$company->name}} @else {{$company->name_bn}} @endif</span></a> @if(session()->get('lang') == 'en') All Rights Reserved. @else সর্বস্বত্ব সংরক্ষিত.  @endif<a href="https://insideitbd.com" target="_blank"><span> </span></a></p>
        </div>
    </div>
</footer>