@extends('admin.master')
@section('title')
Vendor
@endsection

@section('head')
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Create New Vendor</h4>

                        <form action="{{route('vendor.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="name" class="form-label">Owner Name</label>
                                <input type="text" class="form-control" name="name" id="name" placeholder="Enter category name" required>
                                @error('title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" id="email" placeholder="Enter email address" required>
                                @error('email')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="text" class="form-control" name="phone" id="phone" placeholder="Enter phone number" required>
                                @error('phone')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" name="password" id="password" placeholder="Enter vendor password" required>
                                @error('password')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="confirm_password" class="form-label">Confirm Password</label>
                                <input type="password" class="form-control" name="password_confirmation" id="confirm_password" placeholder="Enter vendor password" required>
                                @error('confirm_password')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="row">
                                <div class="col-md-12  mb-3">
                                    <label for="status" class="form-label">Status</label>
                                    <select class="form-control" name="status" placeholder="Select a Published Status..." required>
                                        <option value="1">YES</option>
                                        <option value="0">NO</option>
                                    </select>
                                    @error('status')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <h4 class="mb-3 header-title">Shop Info</h4>
                            <div class="mb-3">
                                <label for="shop_name" class="form-label">Shop Name</label>
                                <input type="text" class="form-control" name="shop_name" id="shop_name" placeholder="Enter shop name" required>
                                @error('shop_name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="image" class="form-label">Logo</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> <img class="img-fluid img-round img-profile" width="100" id="image"
                                            src="{{ asset('backend/img') }}/upload_img.png"
                                            alt="Logo"></label>
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                            </div>
                            <div class="mb-3">
                                <label for="shop_location" class="form-label">Shop Location</label>
                                <input type="text" class="form-control" name="shop_location" id="shop_location" placeholder="Enter shop location" required>
                                @error('shop_location')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="contact_number" class="form-label">Shop Contact Number</label>
                                <input type="text" class="form-control" name="contact_number" id="contact_number" placeholder="Enter shop contact number" required>
                                @error('contact_number')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="another_contact_number" class="form-label">Shop Contact Number (Optional)</label>
                                <input type="text" class="form-control" name="another_contact_number" id="another_contact_number" placeholder="Enter shop contact number">
                                @error('another_contact_number')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">Create</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 1000;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
  

@endsection
