@extends('admin.master')
@section('title') User @endsection
@section('content')
@php
    $index = 1;
@endphp
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="float-end">
                            <a href="{{route('user.create')}}" class="btn btn-purple rounded-pill w-md waves-effect waves-light mb-3"><i class="mdi mdi-plus"></i> Create User</a>
                        </div>
                        <h4 class="mt-0 header-title">User List</h4>
                        <p class="text-muted font-14 mb-3">
                            Used <code>user</code> to add all type f post
                        </p>

                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($users as $user)
                                    <tr>
                                        <th scope="row">{{$index++}}</th>
                                        <td>{{$user->name}}</td>
                                        <td>{{$user->email}}</td>

                                        <td class="text-center">
                                            <a href="{{route('user.edit',$user->id)}}" class="btn btn-purple btn-sm waves-effect waves-light"><i class="mdi mdi-pencil"></i></a>
                                            <button type="button" class="btn btn-danger btn-sm waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$user->id}}"><i class="mdi mdi-delete-outline"></i></button>
                                            
                                        </td>
                                    </tr>

                                    {{-- delete alert --}}
                                    <div id="danger-alert-modal-{{$user->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                        <div class="modal-dialog modal-sm">
                                            <div class="modal-content modal-filled bg-default">
                                                <div class="modal-body">
                                                    <div class="text-center">
                                                        <i class="dripicons-wrong h1 text-danger"></i>
                                                        <h3 class="mt-1">Are you sure?</h3>
                                                        <p class="mt-1">You won't be able to revert this!</p>
                                                        <form action="{{route('user.destroy', $user->id)}}" method="post" class="d-inline-block">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$user->id}}">Yes, delete it!</button>
                                                        </form>
                                                        <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                                    </div>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
    </div>

    {{-- create category model --}}
    <div id="create-category-modal" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-center mt-2 mb-4">
                        <h2>Add User</h2>
                    </div>

                    <form action="{{route('user.store')}}" method="POST" class="px-3">
                        @csrf
                        <div class="mb-3">
                            <label for="name" class="form-label">Name</label>
                            <input class="form-control" type="text" id="name" name="name" required="" placeholder="Enter Category Name">
                        </div>

                        <div class="mb-3 text-center">
                            <button class="btn rounded-pill btn-purple" type="submit"><i class="mdi mdi-plus"></i> Create</button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection
{{-- 
<form action="{{route('hero.update', $hero->id)}}" method="post" class="w-75 m-auto" enctype="multipart/form-data">
    @csrf @method('PUT') --}}

    