@extends('backend.master')
@section('title')
Social Media
@php
    $data = App\Models\SocialMedia::first();
@endphp
@endsection
@section('head')
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Social Media</h4>

                        <form action="{{route('social-media.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="mb-3">
                                <label for="facebook" class="form-label">Facebook</label>
                                <input type="text" class="form-control" name="facebook" value="{{$data->facebook}}" id="facebook" placeholder="Enter facebook link">
                                @error('facebook')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="twitter" class="form-label">Twitter</label>
                                <input type="text" class="form-control" name="twitter" value="{{$data->twitter}}" id="twitter" placeholder="Enter twitter link">
                                @error('twitter')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="linked_in" class="form-label">Linked In</label>
                                <input type="text" class="form-control" name="linked_in" value="{{$data->linked_in}}" id="linked_in" placeholder="Enter linkedin link">
                                @error('linked_in')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="instragram" class="form-label">Instragram</label>
                                <input type="text" class="form-control" maxlength="80" value="{{$data->instragram}}" name="instragram" id="instragram" placeholder="Enter instragram link">
                                @error('instragram')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="youTube" class="form-label">YouTube</label>
                                <input type="text" class="form-control" maxlength="80" value="{{$data->youTube}}" name="youTube" id="youTube" placeholder="Enter youTube link">
                                @error('youTube')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-info waves-effect waves-light">SAVE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection