@extends('backend.master')
@section('title') Slider @endsection
@section('content')
@php
    $index = 1;
@endphp
    <!-- Start Content-->
    <div class="container-fluid">
        <div class="row">
            <div>
                <div class="float-end">
                    <a href="{{route('slider.create')}}" class="btn btn-purple rounded-pill w-md waves-effect waves-light mb-3"><i class="mdi mdi-plus"></i> Create Slider</a>
                </div>
            </div>
            @foreach ($sliders as $slider)
                <div class="col-md-6 col-xl-3">
                    <div class="card">
                        <img class="card-img-top img-fluid" src="{{asset('public')}}/{{$slider->image}}" alt="Card image cap">
                        <div class="card-body">
                            <h4 class="card-title">{{$slider->title_bn}}</h4>
                            <p class="card-text">{{$slider->description_bn}}</p>
                            <a href="{{route('slider.edit',$slider->id)}}" class="btn btn-primary"><i class="mdi mdi-pencil"></i></a>
                            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$slider->id}}"><i class="mdi mdi-delete-outline"></i></button>
                        </div>
                    </div>
                </div>
                {{-- delete alert --}}
                <div id="danger-alert-modal-{{$slider->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-sm">
                        <div class="modal-content modal-filled bg-default">
                            <div class="modal-body">
                                <div class="text-center">
                                    <i class="dripicons-wrong h1 text-danger"></i>
                                    <h3 class="mt-1">Are you sure?</h3>
                                    <p class="mt-1">You won't be able to revert this!</p>
                                    <form action="{{route('slider.destroy', $slider->id)}}" method="post" class="d-inline-block">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$slider->id}}">Yes, delete it!</button>
                                    </form>
                                    <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            
        </div>
    
    </div>

@endsection

    