@extends('backend.master')
@section('title')
Sister Concern
@endsection
@section('head')

@endsection
@section('content')
    @php
        $rank = App\Models\SisterConcern::count() +1;
    @endphp
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Create Sister Concern</h4>

                        <form action="{{route('sister-concern.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="image" class="form-label">Logo (size: 200px X 70px)</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> 
                                    <img class="img-fluid rounded img-profile" width="100" id="image"
                                            src="{{ asset('backend/img') }}/upload_img.png"
                                            alt="About Us Picture"> </label>
                                
                            </div>
                            <div class="mb-3">
                                <label for="company_name_bn" class="form-label">প্রতিষ্ঠানের নাম</label>
                                <input type="text" class="form-control" name="company_name_bn" id="company_name_bn" placeholder="প্রতিষ্ঠানের নাম লিখুন" required>
                                @error('company_name_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="company_name" class="form-label">Company Name</label>
                                <input type="text" class="form-control" name="company_name" id="company_name" placeholder="Enter company name">
                                @error('company_name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" id="email" placeholder="Enter sister concern email" required>
                                @error('email')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="phone_bn" class="form-label">ফোন নম্বর</label>
                                <input type="text" class="form-control" name="phone_bn" id="phone_bn" placeholder="প্রতিষ্ঠানের ফোন নম্বর লিখুন" required>
                                @error('phone_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="text" class="form-control" name="phone" id="phone" placeholder="Enter sister concern phone">
                                @error('phone')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="address_bn" class="form-label">ঠিকানা</label>
                                <textarea type="text" class="form-control" name="address_bn" id="address_bn" placeholder="প্রতিষ্ঠানের ঠিকানা লিখুন"></textarea>
                                @error('address_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea type="text" class="form-control" name="address" id="address" placeholder="Enter sister concern address"></textarea>
                                @error('address')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="link" class="form-label">Website Link</label>
                                <input type="text" class="form-control" name="link" id="link" placeholder="Enter concern website link">
                                @error('link')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="rank" class="form-label">Rank</label>
                                <input type="number" class="form-control" name="rank" value="{{$rank}}"  id="rank" placeholder="Enter rank">
                                @error('rank')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description_bn" class="form-label">বর্ণনা</label>
                                <textarea type="text" class="form-control tinymce" name="description_bn" id="description_bn" placeholder="বর্ণনা লিখুন"></textarea>
                                @error('description_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea type="text" class="form-control tinymce" name="description" id="description" placeholder="Enter description"></textarea>
                                @error('description')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">CREATE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection

@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 400;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
@endsection