@extends('backend.master')
@section('title')
Depot
@endsection
@section('head')
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Update Depot</h4>

                        <form action="{{route('branch.update',$branch->id)}}" method="POST" enctype="multipart/form-data">
                            @csrf @method('PUT')
                           
                            <div class="mb-3">
                                <label for="name_bn" class="form-label">নাম</label>
                                <input type="text" class="form-control" name="name_bn" value="{{$branch->name_bn}}" id="name_bn" placeholder="শাখার নাম লিখুন" required>
                                @error('name_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" value="{{$branch->name}}" id="name" placeholder="Enter branch name">
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" value="{{$branch->email}}" id="email" placeholder="Enter branch email" required>
                                @error('email')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="phone_bn" class="form-label">ফোন নম্বর</label>
                                <input type="text" class="form-control" name="phone_bn" value="{{$branch->phone_bn}}" id="phone_bn" placeholder="শাখার ফোন নম্বর লিখুন" required>
                                @error('phone_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="text" class="form-control" name="phone" value="{{$branch->phone}}" id="phone" placeholder="Enter branch phone">
                                @error('phone')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="address_bn" class="form-label">ঠিকানা</label>
                                <textarea type="text" class="form-control" name="address_bn" id="address_bn" placeholder="শাখার ঠিকানা লিখুন">{{$branch->address_bn}}</textarea>
                                @error('address_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea type="text" class="form-control" name="address" id="address" placeholder="Enter branch address">{{$branch->address}}</textarea>
                                @error('address')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">UPDATE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection