@extends('backend.master')
@section('title')
Company
@php
    $data = App\Models\Company::first();
@endphp
@endsection
@section('head')
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Company Profile</h4>

                        <form action="{{route('company.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="image" class="form-label">Logo (size: 200px X 70px)</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> 
                                    @if(is_null($data->logo))
                                    <img class="img-fluid rounded img-profile" width="100" id="image"
                                            src="{{ asset('backend/img') }}/upload_img.png"
                                            alt="Category Picture"> </label>
                                    @else
                                    
                                    <img class="img-fluid rounded img-profile" width="200" id="image"
                                            src="{{ asset('public') }}/{{$data->logo}}"
                                            alt="Category Picture"> </label>
                                    @endif
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            <div class="mb-3">
                                <label for="favicon" class="form-label">Favicon (size: 55px X 60px)</label>
                                <input type="file" class="d-none" name="favicon" id="input_file2"
                                            onchange="showFavicon.call(this)">
                                    <br>
                                    @error('favicon') <code>{{ $message }}</code> @enderror
                                    <label for="input_file2"><i class="ion-upload"></i> 
                                    @if(is_null($data->favicon))
                                    <img class="img-fluid rounded img-profile" width="100" id="favicon"
                                            src="{{ asset('backend/img') }}/upload_img.png"
                                            alt="Category Picture"> </label>
                                    @else
                                    <img class="img-fluid rounded img-profile" width="60" id="favicon"
                                            src="{{ asset('public') }}/{{$data->favicon}}"
                                            alt="Category Picture"> </label>
                                    @endif
                                    @error('favicon')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            <div class="mb-3">
                                <label for="name_bn" class="form-label">নাম</label>
                                <input type="text" class="form-control" name="name_bn" value="{{$data->name_bn}}" id="name_bn" placeholder="কোম্পানির নাম লিখুন" required>
                                @error('name_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" value="{{$data->name}}" id="name" placeholder="Enter company name">
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" name="email" value="{{$data->email}}" id="email" placeholder="Enter company email" required>
                                @error('email')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="phone_bn" class="form-label">ফোন নম্বর</label>
                                <input type="text" class="form-control" name="phone_bn" value="{{$data->phone_bn}}" id="phone_bn" placeholder="কোম্পানির ফোন নম্বর লিখুন" required>
                                @error('phone_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="text" class="form-control" name="phone" value="{{$data->phone}}" id="phone" placeholder="Enter company phone">
                                @error('phone')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="address_bn" class="form-label">ঠিকানা</label>
                                <textarea type="text" class="form-control" name="address_bn" id="address_bn" placeholder="কোম্পানির ঠিকানা লিখুন">{{$data->address_bn}}</textarea>
                                @error('address_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea type="text" class="form-control" name="address" id="address" placeholder="Enter company address">{{$data->address}}</textarea>
                                @error('address')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_title" class="form-label">Meta Title</label>
                                <input type="text" class="form-control" maxlength="80" value="{{$data->meta_title}}" name="meta_title" id="meta_title" placeholder="Enter meta title">
                                @error('meta_title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_des" class="form-label">Meta Description</label>
                                <textarea type="text" class="form-control" maxlength="180" name="meta_des" id="meta_des" placeholder="Enter meta description">{{$data->meta_des}}</textarea>
                                @error('meta_des')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="google_maps" class="form-label">Google Maps</label>
                                <textarea type="text" class="form-control"  name="google_maps" id="google_maps" placeholder="Enter google maps">{{$data->google_maps}}</textarea>
                                @error('google_maps')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-info waves-effect waves-light">SAVE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 100;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }
    function showFavicon() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("favicon");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 100;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
  

@endsection
