@extends('admin.master')
@section('title')
{{ $product->name }}
@endsection

@section('head')
<link href="{{asset('backend/assets')}}/libs/mohithg-switchery/switchery.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/multiselect/css/multi-select.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/selectize/css/selectize.bootstrap3.css" rel="stylesheet" type="text/css" />
<link href="{{asset('backend/assets')}}/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
<style>
    .post-size{
        width: 20%;
        height: auto;
    }
</style>
@endsection

@section('content')
<!-- Start Content-->
<div class="container-fluid">
    
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body task-detail">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <tbody>
                                
                                <tr>
                                    <th>Vendor</th>
                                    <td>:</td>
                                    <td>{{$product->vendor_id > 0 ? $product->vendor->shop_name : 'Not Assing'}}<a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-vendor-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Product Name</th>
                                    <td>:</td>
                                    <td>
                                        {{$product->name}}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-name-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Regular Price</th>
                                    <td>:</td>
                                    <td>BDT <strong>{{$product->regular_price ?? 0}} </strong> TK
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-regular_price-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Price</th>
                                    <td>:</td>
                                    <td>BDT <strong>{{$product->price ?? 0}}</strong>  TK
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-price-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Condition</th>
                                    <td>:</td>
                                    <td>{{$product->condition}}
                                    
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-condition-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Product Code</th>
                                    <td>:</td>
                                    <td>{{$product->product_code}}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-product_code-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Category</th>
                                    <td>:</td>
                                    <td>{{$product->category->name}}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-category-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Brand</th>
                                    <td>:</td>
                                    <td>{{$product->brand->name}}<a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-brand-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Replacement Granite</th>
                                    <td>:</td>
                                    <td>{{$product->replacement_granite}}<a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-replacement_granite-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Service Warranty</th>
                                    <td>:</td>
                                    <td>{{$product->service_warranty}}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-service_warranty-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Warranty</th>
                                    <td>:</td>
                                    <td>{{$product->warranty}}
                                    <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-warranty-modal"><i class="mdi mdi-pencil"></i></a>
                                </td>
                                </tr>
                                <tr>
                                    <th>Meta Title (SEO)</th>
                                    <td>:</td>
                                    <td>{{$product->meta_title}}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-meta_title-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Meta Description (SEO)</th>
                                    <td>:</td>
                                    <td>{{$product->meta_des}}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-meta_des-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Key Features</th>
                                    <td>:</td>
                                    <td>{!! $product->key_features !!}
                                        <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-key_features-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <th>Published Status</th>
                                    <td>:</td>
                                    <td>
                                        <p> @if($product->status == 0) <span class="badge bg-danger">Unpublish</span> @else <span class="badge bg-success">Publish</span> @endif
                                            <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-status-modal"><i class="mdi mdi-pencil"></i></a>
                                        </p>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <th>Stock Status</th>
                                    <td>:</td>
                                    <td>
                                         <span class="badge bg-info">{{$product->stock_status}}</span>
                                         <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-stock_status-modal"><i class="mdi mdi-pencil"></i></a>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                    <div class="p-2">
                        <h5 class="font-600 m-b-5">Description
                            <a class="btn btn-info btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-description-modal"><i class="mdi mdi-pencil"></i></a>
                        </h5>
                        <p class="text-muted mt-10">
                            {!! $product->description !!}
                        </p>
                    </div>
                    
                   <div class="row p-2">
                        <h5 class="font-600 m-b-5">Images
                            <a class="btn btn-success btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#add-product-img-modal"><i class="mdi mdi-plus"></i></a>
                        </h5>
                        @foreach ($product->images as $img)
                            <div class="col-12 col-md-4 col-lg-3 text-center">
                                <img class="flex-shrink-0 me-3 img-thumbnail" style="height: 250px" alt="{{$product->name}} Img"
                                src="{{$img->link}}">
                                <div class="button-list mt-1">
                                    <form action="{{route('product.primaryImg')}}" method="post" class="d-inline-block">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$img->id}}">
                                        <input type="hidden" name="product_id" value="{{$product->id}}">
                                        <button @if($img->primary == 0) type="submit" @else type="button" @endif class="btn @if($img->primary == 1) btn-success @else btn-soft-secondary @endif waves-effect waves-light"><i class="mdi mdi-star"></i></button>
                                    </form>
                                    <button type="button" class="btn btn-danger waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#delete-product-image-modal-{{$img->id}}"><i class="mdi mdi-close"></i></button>
                                </div>
                            </div>
                            {{-- delete alert --}}
                            <div id="delete-product-image-modal-{{$img->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                <div class="modal-dialog modal-sm">
                                    <div class="modal-content modal-filled bg-default">
                                        <div class="modal-body">
                                            <div class="text-center">
                                                <i class="dripicons-wrong h1 text-danger"></i>
                                                <h3 class="mt-1">Are you sure delete this image?</h3>
                                                <p class="mt-1">You won't be able to revert this!</p>
                                                <form action="{{route('product.deleteImg')}}" method="post" class="d-inline-block">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{$img->id}}">
                                                    <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$img->id}}">Yes, delete it!</button>
                                                </form>
                                                <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                    </div><!-- /.modal-content -->
                                </div><!-- /.modal-dialog -->
                            </div>
                        @endforeach
                   </div>

                </div>
            </div>

        </div>
    </div>
    <h4 class="page-title-main">Specifications
        <a class="btn btn-success btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#add-product-specifications-modal"><i class="mdi mdi-plus"></i>ADD NEW</a>
    </h4>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @foreach ($product->specifications as $specification)
                        <h4 class="header-title mt-0 mb-3 mt-2">{{$specification->title}}
                            <a class="btn btn-outline-danger btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#delete-product-specifications-modal-{{$specification->id}}"><i class="mdi mdi-delete-outline"></i> DELETE</a></h4>
                        <div class="table-responsive">
                            <table class="table table-bordered mb-0">
                                <tbody>
                                    @foreach($specification->roles as $role)
                                        <tr>
                                            <th style="width: 23%">{{$role->title}}</th>
                                            <td>{{$role->value}}
                                                <a class="btn btn-info btn-sm waves-effect ml-2 waves-light float-end" data-bs-toggle="modal" data-bs-target="#update-product-specifications-modal-{{$role->id}}"><i class="mdi mdi-pencil"></i></a>
                                                <a class="btn btn-danger btn-sm waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#delete-specifications-modal-{{$role->id}}"><i class="mdi mdi-delete-outline"></i></a>
                                            </td>
                                        </tr>
                                        {{-- update-product-specifications-modal --}}
                                        <div id="update-product-specifications-modal-{{$role->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-body">
                                                        <div class="text-center mb-1">
                                                            <h2>Update Product Specification</h2>
                                                        </div>

                                                        <form action="{{route('product.updateProductSpecification')}}" method="POST" class="px-3">
                                                            @csrf
                                                            <input type="hidden" name="product_id", value="{{$product->id}}">
                                                            <input type="hidden" name="id", value="{{$role->id}}">
                                                            <div class="row specification mb-2" >
                                                                <div class="col-md-12 pb-2">
                                                                    <label for="specifications" class="form-label mt-3">Specification<code>*</code></label>
                                                                    <select class="form-control" name="name" placeholder="Select Specification..." required>
                                                                        <option value="">Select Specification</option>
                                                                        @foreach ($specifications as $sp)
                                                                            <option value="{{$sp->title}}" @if($sp->title == $specification->title) @selected(true) @endif>{{$sp->title}}</option>
                                                                        @endforeach
                                                                    </select>
                                                                    @error('name')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label for="titles" class="form-label">Specification Title<code>*</code></label>
                                                                    <input type="text" class="form-control" name="title" value="{{$role->title}}" id="titles" placeholder="Enter Specification Title" required>
                                                                    @error('title')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label for="values" class="form-label">Specification Value<code>*</code></label>
                                                                    <input type="text" class="form-control" name="value" value="{{$role->value}}" id="values" placeholder="Enter Specification Value" required>
                                                                    @error('value')
                                                                    <div class="invalid-feedback">
                                                                        {{ $message }}
                                                                    </div>
                                                                    @enderror
                                                                </div>
                                                            </div>

                                                            <div class="mb-3 text-center">
                                                                <button class="btn rounded-pill btn-purple" type="submit"><i class="mdi mdi-pencil"></i> Update</button>
                                                            </div>

                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        {{-- delete specification alert --}}
                                        <div id="delete-specifications-modal-{{$role->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-sm">
                                                <div class="modal-content modal-filled bg-default">
                                                    <div class="modal-body">
                                                        <div class="text-center">
                                                            <i class="dripicons-wrong h1 text-danger"></i>
                                                            <h3 class="mt-1">Are you sure delete this specification?</h3>
                                                            <p class="mt-1">You won't be able to revert this!</p>
                                                            <form action="{{route('product.deleteSpecification')}}" method="post" class="d-inline-block">
                                                                @csrf
                                                                <input type="hidden" name="id" value="{{$role->id}}">
                                                                <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$role->id}}">Yes, delete it!</button>
                                                            </form>
                                                            <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                                        </div>
                                                    </div>
                                                </div><!-- /.modal-content -->
                                            </div><!-- /.modal-dialog -->
                                        </div>

                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="clearfix"></div>
                        {{-- delete specification alert --}}
                        <div id="delete-product-specifications-modal-{{$specification->id}}" class="modal fade" tabindex="-1" style="display: none;" aria-hidden="true">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content modal-filled bg-default">
                                    <div class="modal-body">
                                        <div class="text-center">
                                            <i class="dripicons-wrong h1 text-danger"></i>
                                            <h3 class="mt-1">Are you sure delete this specification?</h3>
                                            <p class="mt-1">You won't be able to revert this!</p>
                                            <form action="{{route('product.deleteProductSpecification')}}" method="post" class="d-inline-block">
                                                @csrf
                                                <input type="hidden" name="id" value="{{$specification->id}}">
                                                <button type="submit" class="btn btn-purple waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#danger-alert-modal-{{$specification->id}}">Yes, delete it!</button>
                                            </form>
                                            <button type="button" class="btn btn-danger waves-effect waves-light my-2" data-bs-dismiss="modal">Cancel</button>
                                        </div>
                                    </div>
                                </div><!-- /.modal-content -->
                            </div><!-- /.modal-dialog -->
                        </div>
                    @endforeach
                </div>
            </div>

        </div>
    </div>

</div>
@include('admin.pages.product.show.productUpdateModel')
@include('admin.pages.product.show.productSpModel')

@endsection
@section('script')

<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 1000;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
<script src="{{asset('backend/assets')}}/libs/selectize/js/standalone/selectize.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/mohithg-switchery/switchery.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/multiselect/js/jquery.multi-select.js"></script>
<script src="{{asset('backend/assets')}}/libs/select2/js/select2.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/jquery-mockjax/jquery.mockjax.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/devbridge-autocomplete/jquery.autocomplete.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
<script src="{{asset('backend/assets')}}/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>

<!-- Init js-->
<script src="{{asset('backend/assets')}}/js/pages/form-advanced.init.js"></script>
@endsection


 




