@extends('backend.master')
@section('title')
Founder Speech
@php
    $data = App\Models\FounderSpeech::first();
@endphp
@endsection
@section('head')
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">Founder Speech</h4>

                        <form action="{{route('founder-speech.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="image" class="form-label">Image</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> 
                                    @if(is_null($data->image))
                                    <img class="img-fluid rounded img-profile" width="100" id="image"
                                            src="{{ asset('public/backend/img') }}/upload_img.png"
                                            alt="About Us Picture"> </label>
                                    @else
                                    <img class="img-fluid rounded img-profile" width="200" id="image"
                                            src="{{ asset('public') }}/{{$data->image}}"
                                            alt="About Us Picture"> </label>
                                    @endif
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            <div class="mb-3">
                                <label for="title_bn" class="form-label">শিরোনাম</label>
                                <input type="text" class="form-control" name="title_bn" value="{{$data->title_bn}}" id="title_bn" placeholder="শিরোনাম নাম লিখুন" required>
                                @error('title_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="title" class="form-label">Title</label>
                                <input type="text" class="form-control" name="title" value="{{$data->title}}" id="title" placeholder="Enter slider title">
                                @error('title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="name_bn" class="form-label">নাম</label>
                                <input type="text" class="form-control" name="name_bn" value="{{$data->name_bn}}" id="name_bn" placeholder="নাম লিখুন" required>
                                @error('name_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" value="{{$data->name}}" id="name" placeholder="Enter name">
                                @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            
                            <div class="mb-3">
                                <label for="designation_bn" class="form-label">উপাধি</label>
                                <input type="text" class="form-control" name="designation_bn" value="{{$data->designation_bn}}" id="designation_bn" placeholder="উপাধি নাম লিখুন" required>
                                @error('designation_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="designation" class="form-label">Designation</label>
                                <input type="text" class="form-control" name="designation" value="{{$data->designation}}" id="designation" placeholder="Enter designation">
                                @error('designation')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="speech_bn" class="form-label">স্পিচ</label>
                                <textarea type="text" class="form-control tinymce" name="speech_bn" id="speech_bn" placeholder="স্পিচ লিখুন">{{$data->speech_bn}}</textarea>
                                @error('speech_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="speech" class="form-label">Speech</label>
                                <textarea type="text" class="form-control tinymce" name="speech" id="speech" placeholder="Enter speech">{{$data->speech}}</textarea>
                                @error('speech')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_title" class="form-label">Meta Title</label>
                                <input type="text" class="form-control" maxlength="80" value="{{$data->meta_title}}" name="meta_title" id="meta_title" placeholder="Enter meta title">
                                @error('meta_title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_des" class="form-label">Meta Description</label>
                                <textarea type="text" class="form-control" maxlength="180" name="meta_des" id="meta_des" placeholder="Enter meta description">{{$data->meta_des}}</textarea>
                                @error('meta_des')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-info waves-effect waves-light">SAVE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 200;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
@endsection
