@extends('backend.master')
@section('title')
About Us
@php
    $data = App\Models\AboutUs::first();
@endphp
@endsection
@section('head')
@endsection
@section('content')
    <!-- Start Content-->
    <div class="container-fluid">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="mb-3 header-title">About Us</h4>

                        <form action="{{route('about.store')}}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="mb-3">
                                <label for="image" class="form-label">Image (size: 565 px × 565 px)</label>
                                <input type="file" class="d-none" name="image" id="input_file1"
                                            onchange="showImage.call(this)">
                                    <br>
                                    @error('image') <code>{{ $message }}</code> @enderror
                                    <label for="input_file1"><i class="ion-upload"></i> 
                                    @if(is_null($data->image))
                                    <img class="img-fluid rounded img-profile" width="100" id="image"
                                            src="{{ asset('public/backend/img') }}/upload_img.png"
                                            alt="About Us Picture"> </label>
                                    @else
                                    <img class="img-fluid rounded img-profile" width="400" id="image"
                                            src="{{ asset('public') }}/{{$data->image}}"
                                            alt="About Us Picture"> </label>
                                    @endif
                                    @error('image')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                
                            </div>
                            <div class="mb-3">
                                <label for="title_bn" class="form-label">শিরোনাম</label>
                                <input type="text" class="form-control" name="title_bn" value="{{$data->title_bn}}" id="title_bn" placeholder="শিরোনাম নাম লিখুন" required>
                                @error('title_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="title" class="form-label">Title</label>
                                <input type="text" class="form-control" name="title" value="{{$data->title}}" id="title" placeholder="Enter slider title">
                                @error('title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>


                            <div class="mb-3">
                                <label for="short_description_bn" class="form-label">সংক্ষিপ্ত বর্ণনা</label>
                                <textarea type="text" class="form-control" name="short_description_bn" rows="5" id="short_description_bn" placeholder="কোম্পানির ঠিকানা লিখুন">{{$data->short_description_bn}}</textarea>
                                @error('short_description_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="short_description" class="form-label">Short Description</label>
                                <textarea type="text" class="form-control" name="short_description" rows="5" id="short_description" placeholder="Enter short description">{{$data->short_description}}</textarea>
                                @error('short_description')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="description_bn" class="form-label">বর্ণনা</label>
                                <textarea type="text" class="form-control tinymce" name="description_bn" id="description_bn" placeholder="বর্ণনা লিখুন">{{$data->description_bn}}</textarea>
                                @error('description_bn')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea type="text" class="form-control tinymce" name="description" id="description" placeholder="Enter description">{{$data->description}}</textarea>
                                @error('description')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_title" class="form-label">Meta Title</label>
                                <input type="text" class="form-control" maxlength="80" value="{{$data->meta_title}}" name="meta_title" id="meta_title" placeholder="Enter meta title">
                                @error('meta_title')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="meta_des" class="form-label">Meta Description</label>
                                <textarea type="text" class="form-control" maxlength="180" name="meta_des" id="meta_des" placeholder="Enter meta description">{{$data->meta_des}}</textarea>
                                @error('meta_des')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <button type="submit" class="btn btn-info waves-effect waves-light">SAVE</button>
                        </form>

                    </div>  <!-- end card-body -->
                </div>  <!-- end card -->
            </div>
        </div>
    
    </div>
@endsection
@section('script')
<script>
    function showImage() {
        if (this.files && this.files[0]) {
            var obj = new FileReader();
            obj.onload = function (data) {
                var image = document.getElementById("image");
                image.src = data.target.result;
                // image.classList.add("img-fluid img-round");
                image.width = 400;
                // image.style.height = 'auto'
            }
            console.log(image);
            obj.readAsDataURL(this.files[0]);
        }
    }

</script>
  

@endsection
