<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title>EWCL | Admin Dashboard</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="{{asset('images')}}/icons/icon.png">

		<!-- App css -->

		<link href="{{asset('public/backend/assets')}}/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

		<!-- icons -->
		<link href="{{asset('public/backend/assets')}}/css/icons.min.css" rel="stylesheet" type="text/css" />

        <!-- Notification css (Toastr) -->
        <link href="{{asset('public/backend/assets')}}/libs/toastr/build/toastr.min.css" rel="stylesheet" type="text/css" />

        <style>
            .mce-panel{
                border-radius: 0.2rem;
                border: 0 solid #e2e4e7 !important;
            }
        </style>

        @yield('head')

    </head>

    <!-- body start -->
    <body class="loading" data-layout-color="light"  data-layout-mode="default" data-layout-size="fluid" data-topbar-color="light" data-leftbar-position="fixed" data-leftbar-color="light" data-leftbar-size='default' data-sidebar-user='true'>

        <!-- Begin page -->
        <div id="wrapper">
            @include('backend.includes.header')
            @include('backend.includes.sidebar')

            <div class="content-page">
                <div class="content">
                    @yield('content')
                </div> 

               @include('backend.includes.footer')
            </div>

        </div>
        <!-- END wrapper -->

        <!-- Vendor -->
        <script src="{{asset('public/backend/assets')}}/libs/jquery/jquery.min.js"></script>
        <script src="{{asset('public/backend/assets')}}/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="{{asset('public/backend/assets')}}/libs/simplebar/simplebar.min.js"></script>
        <script src="{{asset('public/backend/assets')}}/libs/node-waves/waves.min.js"></script>
        <script src="{{asset('public/backend/assets')}}/libs/waypoints/lib/jquery.waypoints.min.js"></script>
        <script src="{{asset('public/backend/assets')}}/libs/jquery.counterup/jquery.counterup.min.js"></script>
        <script src="{{asset('public/backend/assets')}}/libs/feather-icons/feather.min.js"></script>

        <!--tinymce textEditor-->
        <script src="{{asset('public/backend/assets')}}/tinymce/tinymce.min.js"></script>
        <script type="text/javascript" src="{{asset('public/backend/assets')}}/tinymce/init-tinymce.js"></script>


        <!-- App js -->
        <script src="{{asset('public/backend/assets')}}/js/app.min.js"></script>

         <!-- Toastr js -->
         <script src="{{asset('public/backend/assets')}}/libs/toastr/build/toastr.min.js"></script>
         @if(session()->has('message'))
         @include('backend.includes.success')
         @endif
         @if(session()->has('error'))
         @include('backend.includes.error')
         @endif


        @yield('script')

        <script>
            $( document ).ready(function() {
                document.getElementById('responsive-datatable').style.width = null;
            });
        </script>
        
    </body>
</html>