<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Product;

class Category extends Model
{
    use HasFactory;
    
    protected $guarded = [];

    public function product()
    {
        return $this->hasMany(Product::class)->orderBy('rank', 'ASC');;
    }
    public static function data()
    {
        return Category::orderBy('rank','ASC')->get();
    }
    public static function limit($value)
    {
        return Category::orderBy('rank','ASC')->paginate($value);
    }
    public static function getProducts($slug)
    {
        return Category::where('slug',$slug)->orderBy('rank','ASC')->first()->product;
    }
}
