<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory;
    
    protected $guarded = [];
    
    public static function limit($value)
    {
        return Blog::orderBy('rank','ASC')->paginate($value);
    }

    public static function page($limit)
    {
        $list = [];
        $totalPost = count(Blog::select('id')->get());
        $page = $totalPost / $limit;
        $val = $page;
        if(floor( $page ) != $page)
        {
            if($val <= 1)
            {
                $val = 0;
            }else{
                $val = explode('.',$page)[0];
                $val = $val + 1;
            }
        }else{
            if($val <= 1)
            {
                $val = 0;
            }else{
                $val = $page;
            }
        }
        // if($page > 1){
        //     //<li><a href="#">1</a></li>
        //     array_push($list,'<li><a href="/blogs?page=1">1</a></li>','<li><a href="/blogs?page=2">2</a></li>');
        // }
         return $val;
         
    }
}
