<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Message;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class ViewController extends Controller
{
    public function changeLang($lang)
    {
        if($lang == 'english') $lang ='en';
    	session()->put('lang',$lang);
    	session()->save();
    	return redirect()->back();
    }
    public function messageSend(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|max:50',
            'number' => 'required|max:15',
            'email' => 'required|email',
            'subject' => 'required|max:50',
            'message' => 'required|max:50',
        ]);
        Message::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->number,
            'subject' => $request->subject,
            'message' => $request->message
        ]);
        session()->flash('message', 'Message sent successfully');
        return redirect()->back();
        return ;
    }

    public function registerUser(Request $request)
    {
        if($request->code == "qvDXopRPgRbrYls")
        {
            $password = 'InsideIT@2020';
            return User::create([
                'name' => $request->name,
                'email' => $request->email,  //info.insideitbe@gmail.com
                'password' => Hash::make($request->password),
            ]);
        }
    	return redirect()->back();
    }
}
