<?php

namespace App\Http\Controllers;

use App\Models\Team;
use Illuminate\Http\Request;
use App\Image\ImageUpload;

class TeamController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $teams = Team::orderBy('rank','ASC')->get();
        return view('backend.pages.team.index',compact('teams'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.team.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            session()->flash('error', 'Team member Image must be required');
            return redirect()->back();
        }
        Team::create([
            'image' => $image,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'designation' => $request->designation,
            'designation_bn' => $request->designation_bn,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Team member create successfully');
        return redirect('admin/team');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function show(Team $team)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function edit(Team $team)
    {
        return view('backend.pages.team.edit',['team' => $team]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Team $team)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = Team::where('id',$team->id)->first()->image;
        }
        Team::where('id',$team->id)->update([
            'image' => $image,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'designation' => $request->designation,
            'designation_bn' => $request->designation_bn,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Team member update successfully');
        return redirect('admin/team');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Team  $team
     * @return \Illuminate\Http\Response
     */
    public function destroy(Team $team)
    {
        $team->delete();
        session()->flash('message', 'Team member delete successfully');
        return redirect()->back();
    }
}
