<?php

namespace App\Http\Controllers;

use App\Models\SisterConcern;
use App\Image\ImageUpload;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SisterConcernController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $concerns = SisterConcern::orderBy('rank','ASC')->get();
        return view('backend.pages.sister_concern.index',compact('concerns'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.sister_concern.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            session()->flash('error', 'Sister Concern logo must be required');
            return redirect()->back();
        }
        SisterConcern::create([
            'logo' => $image,
            'company_name' => $request->company_name,
            'company_name_bn' => $request->company_name_bn,
            'slug' => Str::slug($request->company_name),
            'email' => $request->email,
            'phone' => $request->phone,
            'phone_bn' => $request->phone_bn,
            'address' => $request->address,
            'address_bn' => $request->address_bn,
            'link' => $request->link,
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Sister concern create successfully');
        return redirect('admin/sister-concern');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SisterConcern  $sisterConcern
     * @return \Illuminate\Http\Response
     */
    public function show(SisterConcern $sisterConcern)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SisterConcern  $sisterConcern
     * @return \Illuminate\Http\Response
     */
    public function edit(SisterConcern $sisterConcern)
    {
        return view('backend.pages.sister_concern.edit',['concern' => $sisterConcern]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\Request  $request
     * @param  \App\Models\SisterConcern  $sisterConcern
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SisterConcern $sisterConcern)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = SisterConcern::where('id',$sisterConcern->id)->first()->logo;
        }
        SisterConcern::where('id',$sisterConcern->id)->update([
            'logo' => $image,
            'company_name' => $request->company_name,
            'company_name_bn' => $request->company_name_bn,
            'slug' => Str::slug($request->company_name),
            'email' => $request->email,
            'phone' => $request->phone,
            'phone_bn' => $request->phone_bn,
            'address' => $request->address,
            'address_bn' => $request->address_bn,
            'link' => $request->link,
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Sister concern update successfully');
        return redirect('admin/sister-concern');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SisterConcern  $sisterConcern
     * @return \Illuminate\Http\Response
     */
    public function destroy(SisterConcern $sisterConcern)
    {
        $sisterConcern->delete();
        session()->flash('message', 'Sister concern delete successfully');
        return redirect()->back();
    }
}
