<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Category;
use App\Image\ImageUpload;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Product::orderBy('id','DESC')->get();
        return view('backend.pages.product.index',compact('products'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::orderBy('rank','ASC')->get();
        return view('backend.pages.product.create',['categories'=> $categories]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            session()->flash('error', 'Product Image must be required');
            return redirect()->back();
        }
        Product::create([
            'category_id' => $request->category_id,
            'image' => $image,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'slug' => Str::slug($request->name),
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Product create successfully');
        return redirect('admin/product');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $product)
    {
        $categories = Category::orderBy('rank','ASC')->get();
        return view('backend.pages.product.edit',['product' => $product,'categories'=> $categories]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Product $product)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = Product::where('id',$product->id)->first()->image;
        }
        Product::where('id',$product->id)->update([
            'image' => $image,
            'category_id' => $request->category_id,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'slug' => Str::slug($request->name),
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Product update successfully');
        return redirect('admin/product');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        $product->delete();
        session()->flash('message', 'Product delete successfully');
        return redirect()->back();
    }
}
