<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Image\ImageUpload;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = Category::orderBy('rank','ASC')->get();
        return view('backend.pages.category.index',compact('categories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.pages.category.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            session()->flash('error', 'Category Image must be required');
            return redirect()->back();
        }
        Category::create([
            'image' => $image,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'slug' => Str::slug($request->name),
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Category create successfully');
        return redirect('admin/category');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function show(Category $category)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function edit(Category $category)
    {
        return view('backend.pages.category.edit',['category' => $category]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Category $category)
    {
        $image = ImageUpload::uploadImageWithoutSize($request,'image');
        if($image == null)
        {
            $image = Category::where('id',$category->id)->first()->image;
        }
        Category::where('id',$category->id)->update([
            'image' => $image,
            'name' => $request->name,
            'name_bn' => $request->name_bn,
            'slug' => Str::slug($request->name),
            'description' => $request->description,
            'description_bn' => $request->description_bn,
            'meta_title' => $request->meta_title,
            'meta_des' => $request->meta_des,
            'rank' => $request->rank,
        ]);
        session()->flash('message', 'Category update successfully');
        return redirect('admin/category');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Category  $category
     * @return \Illuminate\Http\Response
     */
    public function destroy(Category $category)
    {
        $category->delete();
        session()->flash('message', 'Category delete successfully');
        return redirect()->back();
    }
}
